package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.zurrtum.create.catnip.theme.Color;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

public record BoxRenderState(
    Matrix3x2f pose, float x, float y, float width, float height, int f, int c1Red, int c1Green, int c1Blue, int c1Alpha, int c2Red, int c2Green,
    int c2Blue, int c2Alpha, int c3Red, int c3Green, int c3Blue, int c3Alpha, class_8030 bounds
) implements class_11244 {
    public BoxRenderState(Matrix3x2f pose, float x, float y, float width, float height, int f, Color c1, Color c2, Color c3) {
        this(
            pose,
            x,
            y,
            width,
            height,
            f,
            c1.getRed(),
            c1.getGreen(),
            c1.getBlue(),
            c1.getAlpha(),
            c2.getRed(),
            c2.getGreen(),
            c2.getBlue(),
            c2.getAlpha(),
            c3.getRed(),
            c3.getGreen(),
            c3.getBlue(),
            c3.getAlpha(),
            new class_8030((int) x, (int) y, (int) width, (int) height).method_71523(pose)
        );
    }

    @Override
    public RenderPipeline comp_4055() {
        return class_10799.field_56865;
    }

    @Override
    public void method_70917(class_4588 vertexConsumer, float depth) {
        //outer top
        vertexConsumer.method_70815(pose, x - f - 1, y - f - 2, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x - f - 1, y - f - 1, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y - f - 1, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y - f - 2, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        //outer left
        vertexConsumer.method_70815(pose, x - f - 2, y - f - 1, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x - f - 2, y + f + 1 + height, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x - f - 1, y + f + 1 + height, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x - f - 1, y - f - 1, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        //outer bottom
        vertexConsumer.method_70815(pose, x - f - 1, y + f + 1 + height, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x - f - 1, y + f + 2 + height, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y + f + 2 + height, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y + f + 1 + height, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        //outer right
        vertexConsumer.method_70815(pose, x + f + 1 + width, y - f - 1, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y + f + 1 + height, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x + f + 2 + width, y + f + 1 + height, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x + f + 2 + width, y - f - 1, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        //inner background - also render behind the inner edges
        vertexConsumer.method_70815(pose, x - f - 1, y - f - 1, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x - f - 1, y + f + 1 + height, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y + f + 1 + height, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y - f - 1, depth).method_1336(c1Red, c1Green, c1Blue, c1Alpha);
        //inner top - includes corners
        vertexConsumer.method_70815(pose, x - f - 1, y - f - 1, depth).method_1336(c2Red, c2Green, c2Blue, c2Alpha);
        vertexConsumer.method_70815(pose, x - f - 1, y - f, depth).method_1336(c2Red, c2Green, c2Blue, c2Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y - f, depth).method_1336(c2Red, c2Green, c2Blue, c2Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y - f - 1, depth).method_1336(c2Red, c2Green, c2Blue, c2Alpha);
        //inner left - excludes corners
        vertexConsumer.method_70815(pose, x - f - 1, y - f, depth).method_1336(c2Red, c2Green, c2Blue, c2Alpha);
        vertexConsumer.method_70815(pose, x - f - 1, y + f + height, depth).method_1336(c3Red, c3Green, c3Blue, c3Alpha);
        vertexConsumer.method_70815(pose, x - f, y + f + height, depth).method_1336(c3Red, c3Green, c3Blue, c3Alpha);
        vertexConsumer.method_70815(pose, x - f, y - f, depth).method_1336(c2Red, c2Green, c2Blue, c2Alpha);
        //inner bottom - includes corners
        vertexConsumer.method_70815(pose, x - f - 1, y + f + height, depth).method_1336(c3Red, c3Green, c3Blue, c3Alpha);
        vertexConsumer.method_70815(pose, x - f - 1, y + f + 1 + height, depth).method_1336(c3Red, c3Green, c3Blue, c3Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y + f + 1 + height, depth).method_1336(c3Red, c3Green, c3Blue, c3Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y + f + height, depth).method_1336(c3Red, c3Green, c3Blue, c3Alpha);
        //inner right - excludes corners
        vertexConsumer.method_70815(pose, x + f + width, y - f, depth).method_1336(c2Red, c2Green, c2Blue, c2Alpha);
        vertexConsumer.method_70815(pose, x + f + width, y + f + height, depth).method_1336(c3Red, c3Green, c3Blue, c3Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y + f + height, depth).method_1336(c3Red, c3Green, c3Blue, c3Alpha);
        vertexConsumer.method_70815(pose, x + f + 1 + width, y - f, depth).method_1336(c2Red, c2Green, c2Blue, c2Alpha);
    }

    @Override
    public class_11231 comp_4056() {
        return class_11231.method_70899();
    }

    @Override
    public @Nullable class_8030 comp_4069() {
        return null;
    }
}
