package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_10889;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_11515;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_765;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.client.render.*;
import java.util.List;

public class EntityBlockRenderer extends class_11239<EntityBlockRenderState> {
    private static final Int2ObjectMap<GpuTexture> TEXTURES = new Int2ObjectArrayMap<>();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public EntityBlockRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(int key) {
        GpuTexture texture = TEXTURES.remove(key);
        if (texture != null) {
            texture.close();
        }
    }

    @SuppressWarnings("deprecation")
    @Override
    public void render(EntityBlockRenderState block, class_11246 state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        float size = block.size() * windowScaleFactor;
        GpuTexture texture = TEXTURES.get(block.id());
        if (texture == null) {
            texture = GpuTexture.create((int) size);
            TEXTURES.put(block.id(), texture);
        }
        RenderSystem.setProjectionMatrix(field_60042.method_71092(size, size), class_10366.field_54954);
        texture.prepare();
        matrices.method_22903();
        matrices.method_46416(size / 2, size / 2, 0);
        float scale = block.comp_4133() * windowScaleFactor;
        matrices.method_22905(scale, -scale, scale);
        class_310 mc = class_310.method_1551();
        mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        if (block.zRot() != 0) {
            matrices.method_22907(class_7833.field_40718.rotation(block.zRot()));
        }
        if (block.xRot() != 0) {
            matrices.method_22907(class_7833.field_40714.rotation(block.xRot()));
        }
        if (block.yRot() != 0) {
            matrices.method_22907(class_7833.field_40716.rotation(block.yRot()));
        }
        matrices.method_46416(-0.5F, -0.5F, -0.5F);
        class_776 blockRenderManager = mc.method_1541();
        class_1937 world = block.world();
        class_2680 blockState = block.state();
        class_2586 blockEntity = block.entity();
        class_1921 layer = class_4696.method_23679(blockState) == class_11515.field_60926 ? class_4722.method_29382() : class_4722.method_24074();
        SinglePosVirtualBlockGetter lightWorld = SinglePosVirtualBlockGetter.createFullBright();
        lightWorld.blockState(blockState);
        lightWorld.blockEntity(blockEntity);
        List<class_10889> parts = blockRenderManager.method_3349(blockState).method_68512(world.method_8409());
        blockRenderManager.method_3355(blockState, class_2338.field_10980, lightWorld, matrices, field_59933.getBuffer(layer), false, parts);
        class_827<class_2586> renderer = mc.method_31975().method_3550(blockEntity);
        if (renderer != null) {
            class_1937 previousLevel = blockEntity.method_10997();
            class_2680 stateBefore = blockEntity.method_11010();
            blockEntity.method_31662(world);
            blockEntity.method_31664(blockState);
            renderer.method_3569(
                blockEntity,
                0,
                matrices,
                field_59933,
                class_765.field_32767,
                class_4608.field_21444,
                class_243.field_1353
            );
            blockEntity.method_31664(stateBefore);
            blockEntity.method_31662(previousLevel);
        }
        field_59933.method_22993();
        matrices.method_22909();
        texture.clear();
        state.method_71996(new class_11241(
            class_10799.field_59968,
            class_11231.method_70900(texture.textureView()),
            block.method_72127(),
            block.comp_4122(),
            block.comp_4123(),
            block.comp_4124(),
            block.comp_4125(),
            0.0F,
            1.0F,
            1.0F,
            0.0F,
            -1,
            null,
            null
        ));
    }

    @Override
    protected void render(EntityBlockRenderState state, class_4587 matrices) {
    }

    @Override
    protected String method_70906() {
        return "Entity Block";
    }

    @Override
    public Class<EntityBlockRenderState> method_70903() {
        return EntityBlockRenderState.class;
    }
}
