package com.zurrtum.create.client.content.contraptions.actors.contraptionControls;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlock;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class ContraptionControlsRenderer extends SmartBlockEntityRenderer<ContraptionControlsBlockEntity> {

    public ContraptionControlsRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(
        ContraptionControlsBlockEntity blockEntity,
        float pt,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {
        class_2680 blockState = blockEntity.method_11010();
        class_2350 facing = blockState.method_11654(ContraptionControlsBlock.field_11177).method_10153();
        class_243 buttonMovementAxis = VecHelper.rotate(new class_243(0, 1, -.325), AngleHelper.horizontalAngle(facing), class_2351.field_11052);
        class_243 buttonMovement = buttonMovementAxis.method_1021(-0.07f + -1 / 24f * blockEntity.button.getValue(pt));
        class_243 buttonOffset = buttonMovementAxis.method_1021(0.07f);

        ms.method_22903();
        ms.method_22904(buttonMovement.field_1352, buttonMovement.field_1351, buttonMovement.field_1350);
        super.renderSafe(blockEntity, pt, ms, buffer, light, overlay);
        ms.method_22904(buttonOffset.field_1352, buttonOffset.field_1351, buttonOffset.field_1350);

        class_4588 vc = buffer.getBuffer(class_1921.method_23577());
        CachedBuffers.partialFacing(AllPartialModels.CONTRAPTION_CONTROLS_BUTTON, blockState, facing).light(light).renderInto(ms, vc);

        ms.method_22909();

        int i = (((int) blockEntity.indicator.getValue(pt) / 45) % 8) + 8;
        CachedBuffers.partialFacing(AllPartialModels.CONTRAPTION_CONTROLS_INDICATOR.get(i % 8), blockState, facing).light(light).renderInto(ms, vc);
    }

}
