package com.zurrtum.create.client.content.contraptions.bearing;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class StabilizedBearingMovementRenderBehaviour implements MovementRenderBehaviour {
    @Override
    public void renderInContraption(
        MovementContext context,
        VirtualRenderWorld renderWorld,
        ContraptionMatrices matrices,
        class_4597 buffer
    ) {
        if (VisualizationManager.supportsVisualization(context.world))
            return;

        class_2350 facing = context.state.method_11654(class_2741.field_12525);
        PartialModel top = AllPartialModels.BEARING_TOP;
        SuperByteBuffer superBuffer = CachedBuffers.partial(top, context.state);
        float renderPartialTicks = AnimationTickHolder.getPartialTicks();

        // rotate to match blockstate
        Quaternionf orientation = BearingVisual.getBlockStateOrientation(facing);

        // rotate against parent
        float angle = getCounterRotationAngle(context, facing, renderPartialTicks) * facing.method_10171().method_10181();

        Quaternionf rotation = class_7833.method_46356(facing.method_23955()).rotationDegrees(angle);

        rotation.mul(orientation);

        orientation = rotation;

        superBuffer.transform(matrices.getModel());
        superBuffer.rotateCentered(orientation);

        // render
        superBuffer.light(class_761.method_23794(renderWorld, context.localPos)).useLevelLight(context.world, matrices.getWorld())
            .renderInto(matrices.getViewProjection(), buffer.getBuffer(class_1921.method_23577()));
    }

    @Nullable
    @Override
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new StabilizedBearingVisual(visualizationContext, simulationWorld, movementContext);
    }

    static float getCounterRotationAngle(MovementContext context, class_2350 facing, float renderPartialTicks) {
        if (!context.contraption.canBeStabilized(facing, context.localPos))
            return 0;

        float offset = 0;
        class_2350.class_2351 axis = facing.method_10166();
        AbstractContraptionEntity entity = context.contraption.entity;

        if (entity instanceof ControlledContraptionEntity controlledCE) {
            if (context.contraption.canBeStabilized(facing, context.localPos))
                offset = -controlledCE.getAngle(renderPartialTicks);

        } else if (entity instanceof OrientedContraptionEntity orientedCE) {
            if (axis.method_10178())
                offset = -orientedCE.getViewYRot(renderPartialTicks);
            else {
                if (orientedCE.isInitialOrientationPresent() && orientedCE.getInitialOrientation().method_10166() == axis)
                    offset = -orientedCE.getViewXRot(renderPartialTicks);
            }
        }
        return offset;
    }
}
