package com.zurrtum.create.client.content.decoration.slidingDoor;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControl;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlockEntity;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2323;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7923;

public class SlidingDoorRenderer extends SafeBlockEntityRenderer<SlidingDoorBlockEntity> {
    public SlidingDoorRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(SlidingDoorBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_2680 blockState = be.method_11010();
        if (!be.shouldRenderSpecial(blockState))
            return;

        class_2350 facing = blockState.method_11654(class_2323.field_10938);
        class_2350 movementDirection = facing.method_10170();

        if (blockState.method_11654(class_2323.field_10941) == class_2750.field_12588)
            movementDirection = movementDirection.method_10153();

        float value = be.animation.getValue(partialTicks);
        float value2 = class_3532.method_15363(value * 10, 0, 1);

        class_4588 vb = buffer.getBuffer(class_1921.method_23579());
        class_243 offset = class_243.method_24954(movementDirection.method_62675()).method_1021(value * value * 13 / 16f)
            .method_1019(class_243.method_24954(facing.method_62675()).method_1021(value2 * 1 / 32f));

        if (((SlidingDoorBlock) blockState.method_26204()).isFoldingDoor()) {
            Couple<PartialModel> partials = AllPartialModels.FOLDING_DOORS.get(class_7923.field_41175.method_10221(blockState.method_26204()));

            boolean flip = blockState.method_11654(class_2323.field_10941) == class_2750.field_12586;
            for (boolean left : Iterate.trueAndFalse) {
                SuperByteBuffer partial = CachedBuffers.partial(partials.get(left ^ flip), blockState);
                float f = flip ? -1 : 1;

                partial.translate(0, -1 / 512f, 0).translate(class_243.method_24954(facing.method_62675()).method_1021(value2 * 1 / 32f));
                partial.rotateCentered(class_3532.field_29847 * AngleHelper.horizontalAngle(facing.method_10170()), class_2350.field_11036);

                if (flip)
                    partial.translate(0, 0, 1);
                partial.rotateYDegrees(91 * f * value * value);

                if (!left)
                    partial.translate(0, 0, f / 2f).rotateYDegrees(-181 * f * value * value);

                if (flip)
                    partial.translate(0, 0, -1 / 2f);

                partial.light(light).renderInto(ms, vb);
            }

            return;
        }

        for (class_2756 half : class_2756.values()) {
            CachedBuffers.block(blockState.method_11657(class_2323.field_10945, false).method_11657(class_2323.field_10946, half))
                .translate(0, half == class_2756.field_12609 ? 1 - 1 / 512f : 0, 0).translate(offset).light(light).renderInto(ms, vb);
        }

    }

    public static Pair<ScrollInput, Label> createWidget(class_310 mc, int x, int y, Consumer<DoorControl> callback, DoorControl initial) {
        class_1297 entity = mc.field_1719;
        DoorControl playerFacing = entity != null ? switch (entity.method_5735()) {
            case field_11034 -> DoorControl.EAST;
            case field_11039 -> DoorControl.WEST;
            case field_11043 -> DoorControl.NORTH;
            case field_11035 -> DoorControl.SOUTH;
            default -> DoorControl.NONE;
        } : DoorControl.NONE;

        Label label = new Label(x + 4, y + 6, class_2561.method_43473()).withShadow();
        ScrollInput input = new SelectionScrollInput(x, y, 53, 16).forOptions(CreateLang.translatedOptions(
            "contraption.door_control",
            valuesAsString()
        )).titled(CreateLang.translateDirect("contraption.door_control")).calling(s -> {
            DoorControl mode = DoorControl.values()[s];
            label.text = CreateLang.translateDirect("contraption.door_control." + Lang.asId(mode.name()) + ".short");
            callback.accept(mode);
        }).addHint(CreateLang.translateDirect(
            "contraption.door_control.player_facing",
            CreateLang.translateDirect("contraption.door_control." + Lang.asId(playerFacing.name()) + ".short")
        )).setState(initial.ordinal());
        input.onChanged();
        return Pair.of(input, label);
    }

    public static String[] valuesAsString() {
        DoorControl[] values = DoorControl.values();
        return Arrays.stream(values).map(dc -> dc.name().toLowerCase(Locale.ROOT)).toList().toArray(new String[values.length]);
    }
}
