package com.zurrtum.create.client.content.equipment.symmetryWand;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.equipment.symmetryWand.SymmetryWandItem;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.CrossPlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.EmptyMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.PlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.TriplePlaneMirror;
import com.zurrtum.create.infrastructure.component.SymmetryMirror;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_10801;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class SymmetryHandlerClient {
    private static int tickCounter = 0;

    public static void onRenderWorld(class_310 mc, class_4587 ms, class_4597 buffer, class_243 cameraPos) {
        class_746 player = mc.field_1724;
        class_1661 inventory = player.method_31548();
        for (int i = 0, size = class_1661.method_7368(); i < size; i++) {
            class_1799 stackInSlot = inventory.method_5438(i);
            if (!stackInSlot.method_31574(AllItems.WAND_OF_SYMMETRY))
                continue;
            if (!SymmetryWandItem.isEnabled(stackInSlot))
                continue;
            SymmetryMirror mirror = SymmetryWandItem.getMirror(stackInSlot);
            if (mirror instanceof EmptyMirror)
                continue;

            class_2338 pos = class_2338.method_49638(mirror.getPosition());

            double speed = 1 / 16d;
            float yShift = class_3532.method_15374((float) (AnimationTickHolder.getRenderTime() * speed)) / 5f;

            ms.method_22903();
            ms.method_22904(pos.method_10263() - cameraPos.method_10216(), pos.method_10264() - cameraPos.method_10214(), pos.method_10260() - cameraPos.method_10215());
            ms.method_46416(0, yShift + .2f, 0);
            applyModelTransform(mirror, ms);
            class_10801 model = getModel(mirror).get();
            class_4588 builder = buffer.getBuffer(class_1921.method_23577());

            mc.method_1541().method_3350()
                .method_3374(mc.field_1687, List.of(model), class_2246.field_10124.method_9564(), pos, ms, builder, true, class_4608.field_21444);

            ms.method_22909();
        }
    }

    @Nullable
    public static PartialModel getModel(SymmetryMirror mirror) {
        return switch (mirror) {
            case PlaneMirror planeMirror -> AllPartialModels.SYMMETRY_PLANE;
            case CrossPlaneMirror crossPlaneMirror -> AllPartialModels.SYMMETRY_CROSSPLANE;
            case TriplePlaneMirror triplePlaneMirror -> AllPartialModels.SYMMETRY_TRIPLEPLANE;
            default -> throw new IllegalArgumentException("Unknown mirror type: " + mirror.getClass().getName());
        };
    }

    public static void applyModelTransform(SymmetryMirror mirror, class_4587 ms) {
        if (mirror instanceof PlaneMirror) {
            if (mirror.orientation != PlaneMirror.Align.XY) {
                TransformStack.of(ms).center().rotateYDegrees(90).uncenter();
            }
        } else if (mirror instanceof CrossPlaneMirror) {
            if (mirror.orientation != CrossPlaneMirror.Align.Y) {
                TransformStack.of(ms).center().rotateYDegrees(45).uncenter();
            }
        }
    }

    public static void onClientTick(class_310 mc) {
        class_638 world = mc.field_1687;
        if (world == null)
            return;
        if (mc.method_1493())
            return;

        class_746 player = mc.field_1724;
        tickCounter++;

        if (tickCounter % 10 == 0) {
            class_1661 inventory = player.method_31548();
            for (int i = 0, size = class_1661.method_7368(); i < size; i++) {
                class_1799 stackInSlot = inventory.method_5438(i);
                if (stackInSlot.method_31574(AllItems.WAND_OF_SYMMETRY) && SymmetryWandItem.isEnabled(stackInSlot)) {
                    SymmetryMirror mirror = SymmetryWandItem.getMirror(stackInSlot);
                    if (mirror instanceof EmptyMirror)
                        continue;

                    class_5819 random = mc.field_1687.field_9229;
                    double offsetX = (random.method_43058() - 0.5) * 0.3;
                    double offsetZ = (random.method_43058() - 0.5) * 0.3;

                    class_243 pos = mirror.getPosition().method_1031(0.5 + offsetX, 1 / 4d, 0.5 + offsetZ);
                    class_243 speed = new class_243(0, random.method_43058() * 1 / 8f, 0);
                    world.method_8406(class_2398.field_11207, pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, speed.field_1351, speed.field_1350);
                }
            }
        }
    }

    public static void drawEffect(class_310 client, class_2338 from, class_2338 to) {
        class_5819 random = client.field_1687.field_9229;
        double density = 0.8f;
        class_243 start = class_243.method_24954(from).method_1031(0.5, 0.5, 0.5);
        class_243 end = class_243.method_24954(to).method_1031(0.5, 0.5, 0.5);
        class_243 diff = end.method_1020(start);

        class_243 step = diff.method_1029().method_1021(density);
        int steps = (int) (diff.method_1033() / step.method_1033());

        class_638 world = client.field_1687;
        for (int i = 3; i < steps - 1; i++) {
            class_243 pos = start.method_1019(step.method_1021(i));
            class_243 speed = new class_243(0, random.method_43058() * -40f, 0);

            world.method_8406(new class_2390(0x010101, 1), pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, speed.field_1351, speed.field_1350);
        }

        class_243 speed = new class_243(0, random.method_43058() * 1 / 32f, 0);
        class_243 pos = start.method_1019(step.method_1021(2));
        world.method_8406(class_2398.field_11207, pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, speed.field_1351, speed.field_1350);

        speed = new class_243(0, random.method_43058() * 1 / 32f, 0);
        pos = start.method_1019(step.method_1021(steps));
        world.method_8406(class_2398.field_11207, pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, speed.field_1351, speed.field_1350);
    }
}
