package com.zurrtum.create.client.content.equipment.symmetryWand;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.symmetryWand.SymmetryWandItem;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.CrossPlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.EmptyMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.PlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.TriplePlaneMirror;
import com.zurrtum.create.infrastructure.component.SymmetryMirror;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSymmetryWandPacket;
import org.joml.Vector3f;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_7833;

public class SymmetryWandScreen extends AbstractSimiScreen {

    private final AllGuiTextures background = AllGuiTextures.WAND_OF_SYMMETRY;

    private ScrollInput areaType;
    private Label labelType;
    private ScrollInput areaAlign;
    private Label labelAlign;
    private IconButton confirmButton;
    private ElementWidget renderedItem;
    private ElementWidget renderedBlock;

    private final class_2561 mirrorType = CreateLang.translateDirect("gui.symmetryWand.mirrorType");
    private final class_2561 orientation = CreateLang.translateDirect("gui.symmetryWand.orientation");

    private SymmetryMirror currentElement;
    private final class_1799 wand;
    private final class_1268 hand;

    public SymmetryWandScreen(class_1799 wand, class_1268 hand) {
        currentElement = SymmetryWandItem.getMirror(wand);
        if (currentElement instanceof EmptyMirror) {
            currentElement = new PlaneMirror(class_243.field_1353);
        }
        this.hand = hand;
        this.wand = wand;
    }

    public static List<class_2561> getMirrors() {
        return ImmutableList.of(
            CreateLang.translateDirect("symmetry.mirror.plane"),
            CreateLang.translateDirect("symmetry.mirror.doublePlane"),
            CreateLang.translateDirect("symmetry.mirror.triplePlane")
        );
    }

    public static List<class_2561> getAlignToolTips(SymmetryMirror element) {
        return switch (element) {
            case PlaneMirror planeMirror ->
                ImmutableList.of(CreateLang.translateDirect("orientation.alongZ"), CreateLang.translateDirect("orientation.alongX"));
            case CrossPlaneMirror crossPlaneMirror ->
                ImmutableList.of(CreateLang.translateDirect("orientation.orthogonal"), CreateLang.translateDirect("orientation.diagonal"));
            case TriplePlaneMirror triplePlaneMirror -> ImmutableList.of(CreateLang.translateDirect("orientation.horizontal"));
            default -> ImmutableList.of();
        };
    }

    @Override
    public void method_25426() {
        setWindowSize(background.getWidth(), background.getHeight());
        setWindowOffset(-20, 0);
        super.method_25426();

        int x = guiLeft;
        int y = guiTop;

        labelType = new Label(x + 51, y + 28, class_5244.field_39003).colored(0xFFFFFFFF).withShadow();
        labelAlign = new Label(x + 51, y + 50, class_5244.field_39003).colored(0xFFFFFFFF).withShadow();

        int state = currentElement instanceof TriplePlaneMirror ? 2 : currentElement instanceof CrossPlaneMirror ? 1 : 0;
        areaType = new SelectionScrollInput(x + 45, y + 21, 109, 18).forOptions(getMirrors()).titled(mirrorType.method_27662())
            .writingTo(labelType).setState(state);

        areaType.calling(position -> {
            switch (position) {
                case 0:
                    currentElement = new PlaneMirror(currentElement.getPosition());
                    break;
                case 1:
                    currentElement = new CrossPlaneMirror(currentElement.getPosition());
                    break;
                case 2:
                    currentElement = new TriplePlaneMirror(currentElement.getPosition());
                    break;
                default:
                    break;
            }
            initAlign(currentElement, x, y);
            ((GuiGameElement.GuiPartialRenderBuilder) renderedBlock.getRenderElement()).partial(SymmetryHandlerClient.getModel(currentElement));
        });

        initAlign(currentElement, x, y);

        method_37063(labelAlign);
        method_37063(areaType);
        method_37063(labelType);

        confirmButton = new IconButton(x + background.getWidth() - 33, y + background.getHeight() - 24, AllIcons.I_CONFIRM);
        confirmButton.withCallback(this::method_25419);
        method_37063(confirmButton);

        renderedItem = new ElementWidget(x + 140, y - 4).showingElement(GuiGameElement.of(wand).rotate(-70, 20, 20).scale(4).padding(100));
        method_37063(renderedItem);

        renderedBlock = new ElementWidget(x + 23, y + 24).showingElement(GuiGameElement.of(SymmetryHandlerClient.getModel(currentElement))
            .transform(this::transformBlock));
        method_37063(renderedBlock);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
        renderedBlock.getRenderElement().clear();
    }

    private void initAlign(SymmetryMirror element, int x, int y) {
        if (areaAlign != null)
            method_37066(areaAlign);

        areaAlign = new SelectionScrollInput(x + 45, y + 43, 109, 18).forOptions(getAlignToolTips(element)).titled(orientation.method_27662())
            .writingTo(labelAlign).setState(element.getOrientationIndex()).calling(index -> {
                element.setOrientation(index);
                ((GuiGameElement.GuiPartialRenderBuilder) renderedBlock.getRenderElement()).markDirty();
            });

        method_37063(areaAlign);
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = guiLeft;
        int y = guiTop;

        background.render(graphics, x, y);
        graphics.method_51439(
            field_22793,
            wand.method_7964(),
            x + (background.getWidth() - field_22793.method_27525(wand.method_7964())) / 2,
            y + 4,
            0xFF592424,
            false
        );
    }

    private void transformBlock(class_4587 ms, float p) {
        ms.method_46416(0.1875F, 0.9375f, 0);
        ms.method_22907(class_7833.method_46356(new Vector3f(.3f, 1f, 0f)).rotationDegrees(-22.5f));
        ms.method_22905(1, -1, 1);
        SymmetryHandlerClient.applyModelTransform(currentElement, ms);
    }

    @Override
    public void method_25432() {
        SymmetryWandItem.configureSettings(wand, currentElement);
        field_22787.field_1724.field_3944.method_52787(new ConfigureSymmetryWandPacket(hand, currentElement));
    }

}