package com.zurrtum.create.client.content.fluids.pipes.valve;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.fluids.pipes.valve.FluidValveBlock;
import com.zurrtum.create.content.fluids.pipes.valve.FluidValveBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class FluidValveRenderer extends KineticBlockEntityRenderer<FluidValveBlockEntity> {

    public FluidValveRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(FluidValveBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {

        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        class_2680 blockState = be.method_11010();
        SuperByteBuffer pointer = CachedBuffers.partial(AllPartialModels.FLUID_VALVE_POINTER, blockState);
        class_2350 facing = blockState.method_11654(FluidValveBlock.FACING);

        float pointerRotation = class_3532.method_48781(be.pointer.getValue(partialTicks), 0, -90);
        class_2351 pipeAxis = FluidValveBlock.getPipeAxis(blockState);
        class_2351 shaftAxis = getRotationAxisOf(be);

        int pointerRotationOffset = 0;
        if (pipeAxis.method_10179() && shaftAxis == class_2351.field_11048 || pipeAxis.method_10178())
            pointerRotationOffset = 90;

        pointer.center().rotateYDegrees(AngleHelper.horizontalAngle(facing))
            .rotateXDegrees(facing == class_2350.field_11036 ? 0 : facing == class_2350.field_11033 ? 180 : 90).rotateYDegrees(pointerRotationOffset + pointerRotation)
            .uncenter().light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
    }

    @Override
    protected class_2680 getRenderedBlockState(FluidValveBlockEntity be) {
        return shaft(getRotationAxisOf(be));
    }

}
