package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.render.RenderTypes;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity.ConnectionStats;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.logistics.box.PackageItem;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_7923;
import net.minecraft.client.render.*;
import org.joml.Matrix4f;

import java.util.List;
import java.util.Map;

public class ChainConveyorRenderer extends KineticBlockEntityRenderer<ChainConveyorBlockEntity> {

    public static final class_2960 CHAIN_LOCATION = class_2960.method_60656("textures/block/chain.png");
    public static final int MIP_DISTANCE = 48;

    public ChainConveyorRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(
        ChainConveyorBlockEntity be,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        class_2338 pos = be.method_11016();

        renderChains(be, ms, buffer, light, overlay);

        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_WHEEL, be.method_11010()).light(light).overlay(overlay)
            .renderInto(ms, buffer.getBuffer(class_1921.method_23579()));

        for (ChainConveyorPackage box : be.getLoopingPackages())
            renderBox(be, ms, buffer, overlay, pos, box, partialTicks);
        for (Map.Entry<class_2338, List<ChainConveyorPackage>> entry : be.getTravellingPackages().entrySet())
            for (ChainConveyorPackage box : entry.getValue())
                renderBox(be, ms, buffer, overlay, pos, box, partialTicks);
    }

    private void renderBox(
        ChainConveyorBlockEntity be,
        class_4587 ms,
        class_4597 buffer,
        int overlay,
        class_2338 pos,
        ChainConveyorPackage box,
        float partialTicks
    ) {
        if (box.worldPosition == null)
            return;
        if (box.item == null || box.item.method_7960())
            return;

        ChainConveyorPackagePhysicsData physicsData = ChainConveyorClientBehaviour.physicsData(box, be.method_10997());
        if (physicsData.prevPos == null)
            return;

        class_243 position = physicsData.prevPos.method_35590(physicsData.pos, partialTicks);
        class_243 targetPosition = physicsData.prevTargetPos.method_35590(physicsData.targetPos, partialTicks);
        float yaw = AngleHelper.angleLerp(partialTicks, physicsData.prevYaw, physicsData.yaw);
        class_243 offset = new class_243(targetPosition.field_1352 - pos.method_10263(), targetPosition.field_1351 - pos.method_10264(), targetPosition.field_1350 - pos.method_10260());

        class_2338 containingPos = class_2338.method_49638(position);
        class_1937 level = be.method_10997();
        class_2680 blockState = be.method_11010();
        int light = class_765.method_23687(
            level.method_8314(class_1944.field_9282, containingPos),
            level.method_8314(class_1944.field_9284, containingPos)
        );

        if (physicsData.modelKey == null) {
            class_2960 key = class_7923.field_41178.method_10221(box.item.method_7909());
            if (key == class_7923.field_41178.method_10137())
                return;
            physicsData.modelKey = key;
        }

        SuperByteBuffer rigBuffer = CachedBuffers.partial(AllPartialModels.PACKAGE_RIGGING.get(physicsData.modelKey), blockState);
        SuperByteBuffer boxBuffer = CachedBuffers.partial(AllPartialModels.PACKAGES.get(physicsData.modelKey), blockState);

        class_243 dangleDiff = VecHelper.rotate(targetPosition.method_1031(0, 0.5, 0).method_1020(position), -yaw, class_2351.field_11052);
        float zRot = class_3532.method_15393((float) class_3532.method_15349(-dangleDiff.field_1352, dangleDiff.field_1351) * class_3532.field_29848) / 2;
        float xRot = class_3532.method_15393((float) class_3532.method_15349(dangleDiff.field_1350, dangleDiff.field_1351) * class_3532.field_29848) / 2;
        zRot = class_3532.method_15363(zRot, -25, 25);
        xRot = class_3532.method_15363(xRot, -25, 25);

        for (SuperByteBuffer buf : new SuperByteBuffer[]{rigBuffer, boxBuffer}) {
            buf.translate(offset);
            buf.translate(0, 10 / 16f, 0);
            buf.rotateYDegrees(yaw);

            buf.rotateZDegrees(zRot);
            buf.rotateXDegrees(xRot);

            if (physicsData.flipped && buf == rigBuffer)
                buf.rotateYDegrees(180);

            buf.uncenter();
            buf.translate(0, -PackageItem.getHookDistance(box.item) + 7 / 16f, 0);

            buf.light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
        }
    }

    private void renderChains(ChainConveyorBlockEntity be, class_4587 ms, class_4597 buffer, int light, int overlay) {
        float time = AnimationTickHolder.getRenderTime(be.method_10997()) / (360f / Math.abs(be.getSpeed()));
        time %= 1;
        if (time < 0)
            time += 1;

        float animation = time - 0.5f;

        for (class_2338 blockPos : be.connections) {
            ConnectionStats stats = be.connectionStats.get(blockPos);
            if (stats == null)
                continue;

            class_243 diff = stats.end().method_1020(stats.start());
            double yaw = (float) class_3532.field_29848 * class_3532.method_15349(diff.field_1352, diff.field_1350);
            double pitch = (float) class_3532.field_29848 * class_3532.method_15349(diff.field_1351, diff.method_18805(1, 0, 1).method_1033());

            class_1937 level = be.method_10997();
            class_2338 tilePos = be.method_11016();
            class_243 startOffset = stats.start().method_1020(class_243.method_24953(tilePos));

            if (!VisualizationManager.supportsVisualization(be.method_10997())) {
                SuperByteBuffer guard = CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_GUARD, be.method_11010());
                guard.center();
                guard.rotateYDegrees((float) yaw);

                guard.uncenter();
                guard.light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
            }

            ms.method_22903();
            var chain = TransformStack.of(ms);
            chain.center();
            chain.translate(startOffset);
            chain.rotateYDegrees((float) yaw);
            chain.rotateXDegrees(90 - (float) pitch);
            chain.rotateYDegrees(45);
            chain.translate(0, 8 / 16f, 0);
            chain.uncenter();

            int light1 = class_765.method_23687(level.method_8314(class_1944.field_9282, tilePos), level.method_8314(class_1944.field_9284, tilePos));
            int light2 = class_765.method_23687(
                level.method_8314(class_1944.field_9282, tilePos.method_10081(blockPos)),
                level.method_8314(class_1944.field_9284, tilePos.method_10081(blockPos))
            );

            boolean far = class_310.method_1551().field_1687 == be.method_10997() && !class_310.method_1551()
                .method_31975().field_4344.method_19326()
                .method_24802(class_243.method_24953(tilePos).method_1031(blockPos.method_10263() / 2f, blockPos.method_10264() / 2f, blockPos.method_10260() / 2f), MIP_DISTANCE);

            renderChain(ms, buffer, animation, stats.chainLength(), light1, light2, far);

            ms.method_22909();
        }
    }

    public static void renderChain(
        class_4587 ms,
        class_4597 buffer,
        float animation,
        float length,
        int light1,
        int light2,
        boolean far
    ) {
        float radius = far ? 1f / 16f : 1.5f / 16f;
        float minV = far ? 0 : animation;
        float maxV = far ? 1 / 16f : length + minV;
        float minU = far ? 3 / 16f : 0;
        float maxU = far ? 4 / 16f : 3 / 16f;

        ms.method_22903();
        ms.method_22904(0.5D, 0.0D, 0.5D);

        class_4588 vc = buffer.getBuffer(RenderTypes.chain(CHAIN_LOCATION));
        renderPart(ms, vc, length, 0.0F, radius, radius, 0.0F, -radius, 0.0F, 0.0F, -radius, minU, maxU, minV, maxV, light1, light2, far);

        ms.method_22909();
    }

    private static void renderPart(
        class_4587 pPoseStack,
        class_4588 pConsumer,
        float pMaxY,
        float pX0,
        float pZ0,
        float pX1,
        float pZ1,
        float pX2,
        float pZ2,
        float pX3,
        float pZ3,
        float pMinU,
        float pMaxU,
        float pMinV,
        float pMaxV,
        int light1,
        int light2,
        boolean far
    ) {
        class_4587.class_4665 posestack$pose = pPoseStack.method_23760();
        Matrix4f matrix4f = posestack$pose.method_23761();

        float uO = far ? 0f : 3 / 16f;
        renderQuad(matrix4f, posestack$pose, pConsumer, 0, pMaxY, pX0, pZ0, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        renderQuad(matrix4f, posestack$pose, pConsumer, 0, pMaxY, pX3, pZ3, pX0, pZ0, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        renderQuad(matrix4f, posestack$pose, pConsumer, 0, pMaxY, pX1, pZ1, pX2, pZ2, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
        renderQuad(matrix4f, posestack$pose, pConsumer, 0, pMaxY, pX2, pZ2, pX1, pZ1, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
    }

    private static void renderQuad(
        Matrix4f pPose,
        class_4587.class_4665 pNormal,
        class_4588 pConsumer,
        float pMinY,
        float pMaxY,
        float pMinX,
        float pMinZ,
        float pMaxX,
        float pMaxZ,
        float pMinU,
        float pMaxU,
        float pMinV,
        float pMaxV,
        int light1,
        int light2
    ) {
        addVertex(pPose, pNormal, pConsumer, pMaxY, pMinX, pMinZ, pMaxU, pMinV, light2);
        addVertex(pPose, pNormal, pConsumer, pMinY, pMinX, pMinZ, pMaxU, pMaxV, light1);
        addVertex(pPose, pNormal, pConsumer, pMinY, pMaxX, pMaxZ, pMinU, pMaxV, light1);
        addVertex(pPose, pNormal, pConsumer, pMaxY, pMaxX, pMaxZ, pMinU, pMinV, light2);
    }

    private static void addVertex(
        Matrix4f pPose,
        class_4587.class_4665 pNormal,
        class_4588 pConsumer,
        float pY,
        float pX,
        float pZ,
        float pU,
        float pV,
        int light
    ) {
        pConsumer.method_22918(pPose, pX, pY, pZ).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(pU, pV).method_22922(class_4608.field_21444).method_60803(light)
            .method_60831(pNormal, 0.0F, 1.0F, 0.0F);
    }

    @Override
    public int method_33893() {
        return 256;
    }

    @Override
    public boolean method_3563() {
        return true;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(ChainConveyorBlockEntity be, class_2680 state) {
        return CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_SHAFT, state);
    }

    @Override
    protected class_1921 getRenderType(ChainConveyorBlockEntity be, class_2680 state) {
        return class_1921.method_23579();
    }

}
