package com.zurrtum.create.client.content.kinetics.crafter;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity.Phase;
import com.zurrtum.create.content.kinetics.crafter.RecipeGridHandler.GroupedItems;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.util.math.*;

import static com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock.HORIZONTAL_FACING;

public class MechanicalCrafterRenderer extends SafeBlockEntityRenderer<MechanicalCrafterBlockEntity> {

    public MechanicalCrafterRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(
        MechanicalCrafterBlockEntity be,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {
        ms.method_22903();
        class_2350 facing = be.method_11010().method_11654(HORIZONTAL_FACING);
        class_243 vec = class_243.method_24954(facing.method_62675()).method_1021(.58).method_1031(.5, .5, .5);

        if (be.phase == Phase.EXPORTING) {
            class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(be.method_11010());
            float progress = class_3532.method_15363((1000 - be.countDown + be.getCountDownSpeed() * partialTicks) / 1000f, 0, 1);
            vec = vec.method_1019(class_243.method_24954(targetDirection.method_62675()).method_1021(progress * .75f));
        }

        ms.method_22904(vec.field_1352, vec.field_1351, vec.field_1350);
        ms.method_22905(1 / 2f, 1 / 2f, 1 / 2f);
        float yRot = AngleHelper.horizontalAngle(facing);
        ms.method_22907(class_7833.field_40716.rotationDegrees(yRot));
        renderItems(be, partialTicks, ms, buffer, light, overlay);
        ms.method_22909();

        renderFast(be, partialTicks, ms, buffer, light);
    }

    public void renderItems(
        MechanicalCrafterBlockEntity be,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {
        if (be.phase == Phase.IDLE) {
            class_1799 stack = be.getInventory().getStack();
            if (!stack.method_7960()) {
                ms.method_22903();
                ms.method_46416(0, 0, -1 / 256f);
                ms.method_22907(class_7833.field_40716.rotationDegrees(180));
                class_310.method_1551().method_1480()
                    .method_23178(stack, class_811.field_4319, light, overlay, ms, buffer, be.method_10997(), 0);
                ms.method_22909();
            }
        } else {
            // render grouped items
            GroupedItems items = be.groupedItems;
            float distance = .5f;

            ms.method_22903();

            if (be.phase == Phase.CRAFTING) {
                items = be.groupedItemsBeforeCraft;
                items.calcStats();
                float progress = class_3532.method_15363((2000 - be.countDown + be.getCountDownSpeed() * partialTicks) / 1000f, 0, 1);
                float earlyProgress = class_3532.method_15363(progress * 2, 0, 1);
                float lateProgress = class_3532.method_15363(progress * 2 - 1, 0, 1);

                ms.method_22905(1 - lateProgress, 1 - lateProgress, 1 - lateProgress);
                class_243 centering = new class_243(-items.minX + (-items.width + 1) / 2f, -items.minY + (-items.height + 1) / 2f, 0).method_1021(earlyProgress);
                ms.method_22904(centering.field_1352 * .5f, centering.field_1351 * .5f, 0);
                distance += (-4 * (progress - .5f) * (progress - .5f) + 1) * .25f;
            }

            boolean onlyRenderFirst = be.phase == Phase.INSERTING || be.phase == Phase.CRAFTING && be.countDown < 1000;
            final float spacing = distance;
            class_918 itemRenderer = class_310.method_1551().method_1480();
            class_1937 world = be.method_10997();
            items.grid.forEach((pair, stack) -> {
                if (onlyRenderFirst && (pair.getFirst() != 0 || pair.getSecond() != 0))
                    return;

                ms.method_22903();
                Integer x = pair.getFirst();
                Integer y = pair.getSecond();
                ms.method_46416(x * spacing, y * spacing, 0);

                int offset = 0;
                if (be.phase == Phase.EXPORTING) {
                    class_2680 state = be.method_11010();
                    if (state.method_28498(MechanicalCrafterBlock.POINTING)) {
                        Pointing value = state.method_11654(MechanicalCrafterBlock.POINTING);
                        offset = value == Pointing.UP ? -1 : value == Pointing.LEFT ? 2 : value == Pointing.RIGHT ? -2 : 1;
                    }
                }

                TransformStack.of(ms).rotateYDegrees(180).translate(0, 0, (x + y * 3 + offset * 9) / 1024f);
                itemRenderer.method_23178(stack, class_811.field_4319, light, overlay, ms, buffer, world, 0);
                ms.method_22909();
            });

            ms.method_22909();

            if (be.phase == Phase.CRAFTING) {
                items = be.groupedItems;
                float progress = class_3532.method_15363((1000 - be.countDown + be.getCountDownSpeed() * partialTicks) / 1000f, 0, 1);
                float earlyProgress = class_3532.method_15363(progress * 2, 0, 1);
                float lateProgress = class_3532.method_15363(progress * 2 - 1, 0, 1);

                ms.method_22907(class_7833.field_40718.rotationDegrees(earlyProgress * 2 * 360));
                float upScaling = earlyProgress * 1.125f;
                float downScaling = 1 + (1 - lateProgress) * .125f;
                ms.method_22905(upScaling, upScaling, upScaling);
                ms.method_22905(downScaling, downScaling, downScaling);

                items.grid.forEach((pair, stack) -> {
                    if (pair.getFirst() != 0 || pair.getSecond() != 0)
                        return;
                    ms.method_22903();
                    ms.method_22907(class_7833.field_40716.rotationDegrees(180));
                    itemRenderer.method_23178(stack, class_811.field_4319, light, overlay, ms, buffer, world, 0);
                    ms.method_22909();
                });
            }

        }
    }

    public void renderFast(MechanicalCrafterBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light) {
        class_2680 blockState = be.method_11010();
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());

        if (!VisualizationManager.supportsVisualization(be.method_10997())) {
            SuperByteBuffer superBuffer = CachedBuffers.partial(AllPartialModels.SHAFTLESS_COGWHEEL, blockState);
            KineticBlockEntityRenderer.standardKineticRotationTransform(superBuffer, be, light);
            superBuffer.rotateCentered((float) (blockState.method_11654(HORIZONTAL_FACING).method_10166() != class_2350.class_2351.field_11048 ? 0 : Math.PI / 2), class_2350.field_11036);
            superBuffer.rotateCentered((float) (Math.PI / 2), class_2350.field_11034);
            superBuffer.renderInto(ms, vb);
        }

        class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(blockState);
        class_2338 pos = be.method_11016();
        if ((be.covered || be.phase != Phase.IDLE) && be.phase != Phase.CRAFTING && be.phase != Phase.INSERTING) {
            SuperByteBuffer lidBuffer = renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_LID, blockState);
            lidBuffer.light(light).renderInto(ms, vb);
        }

        if (MechanicalCrafterBlock.isValidTarget(be.method_10997(), pos.method_10093(targetDirection), blockState)) {
            SuperByteBuffer beltBuffer = renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_BELT, blockState);
            SuperByteBuffer beltFrameBuffer = renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_BELT_FRAME, blockState);

            if (be.phase == Phase.EXPORTING) {
                int textureIndex = (int) ((be.getCountDownSpeed() / 128f * AnimationTickHolder.getTicks()));
                beltBuffer.shiftUVtoSheet(AllSpriteShifts.CRAFTER_THINGIES, (textureIndex % 4) / 4f, 0, 1);
            }

            beltBuffer.light(light).renderInto(ms, vb);
            beltFrameBuffer.light(light).renderInto(ms, vb);

        } else {
            SuperByteBuffer arrowBuffer = renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_ARROW, blockState);
            arrowBuffer.light(light).renderInto(ms, vb);
        }

    }

    private SuperByteBuffer renderAndTransform(PartialModel renderBlock, class_2680 crafterState) {
        SuperByteBuffer buffer = CachedBuffers.partial(renderBlock, crafterState);
        float xRot = crafterState.method_11654(MechanicalCrafterBlock.POINTING).getXRotation();
        float yRot = AngleHelper.horizontalAngle(crafterState.method_11654(HORIZONTAL_FACING));
        buffer.rotateCentered((float) ((yRot + 90) / 180 * Math.PI), class_2350.field_11036);
        buffer.rotateCentered((float) ((xRot) / 180 * Math.PI), class_2350.field_11034);
        return buffer;
    }

}
