package com.zurrtum.create.client.content.kinetics.deployer;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity.Mode;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity.State;
import net.minecraft.class_1747;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.util.math.*;

import static com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE;
import static com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock.FACING;

public class DeployerRenderer extends SafeBlockEntityRenderer<DeployerBlockEntity> {

    public DeployerRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(DeployerBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        renderItem(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity(be, partialTicks, ms, buffer, light, overlay);

        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        renderComponents(be, partialTicks, ms, buffer, light);
    }

    protected void renderItem(DeployerBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {

        if (be.heldItem.method_7960())
            return;

        class_2680 deployerState = be.method_11010();
        class_243 offset = getHandOffset(be, partialTicks, deployerState).method_1019(VecHelper.getCenterOf(class_2338.field_11176));
        ms.method_22903();
        ms.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);

        class_2350 facing = deployerState.method_11654(FACING);
        boolean punching = be.mode == Mode.PUNCH;

        float yRot = AngleHelper.horizontalAngle(facing) + 180;
        float xRot = facing == class_2350.field_11036 ? 90 : facing == class_2350.field_11033 ? 270 : 0;
        boolean displayMode = facing == class_2350.field_11036 && be.getSpeed() == 0 && !punching;

        ms.method_22907(class_7833.field_40716.rotationDegrees(yRot));
        if (!displayMode) {
            ms.method_22907(class_7833.field_40714.rotationDegrees(xRot));
            ms.method_46416(0, 0, -11 / 16f);
        }

        if (punching)
            ms.method_46416(0, 1 / 8f, -1 / 16f);

        class_918 itemRenderer = class_310.method_1551().method_1480();

        class_811 transform;
        if (displayMode) {
            transform = class_811.field_4318;
        } else {
            transform = punching ? class_811.field_4320 : class_811.field_4319;
        }
        itemRenderer.field_55296.method_65598(itemRenderer.field_55297, be.heldItem, transform, be.method_10997(), null, 0);
        boolean isBlockItem = (be.heldItem.method_7909() instanceof class_1747) && itemRenderer.field_55297.method_65608();
        if (displayMode) {
            float scale = isBlockItem ? 1.25f : 1;
            ms.method_46416(0, isBlockItem ? 9 / 16f : 11 / 16f, 0);
            ms.method_22905(scale, scale, scale);
            ms.method_22907(class_7833.field_40716.rotationDegrees(AnimationTickHolder.getRenderTime(be.method_10997())));
        } else {
            float scale = punching ? .75f : isBlockItem ? .75f - 1 / 64f : .5f;
            ms.method_22905(scale, scale, scale);
        }

        itemRenderer.field_55297.method_65604(ms, buffer, light, overlay);
        ms.method_22909();
    }

    protected void renderComponents(DeployerBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light) {
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        if (!VisualizationManager.supportsVisualization(be.method_10997())) {
            KineticBlockEntityRenderer.renderRotatingKineticBlock(be, getRenderedBlockState(be), ms, vb, light);
        }

        class_2680 blockState = be.method_11010();
        class_243 offset = getHandOffset(be, partialTicks, blockState);

        SuperByteBuffer pole = CachedBuffers.partial(AllPartialModels.DEPLOYER_POLE, blockState);
        SuperByteBuffer hand = CachedBuffers.partial(getHandPose(be), blockState);

        transform(pole.translate(offset.field_1352, offset.field_1351, offset.field_1350), blockState, true).light(light).renderInto(ms, vb);
        transform(hand.translate(offset.field_1352, offset.field_1351, offset.field_1350), blockState, false).light(light).renderInto(ms, vb);
    }

    public static PartialModel getHandPose(DeployerBlockEntity be) {
        return be.mode == Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : be.heldItem.method_7960() ? AllPartialModels.DEPLOYER_HAND_POINTING : AllPartialModels.DEPLOYER_HAND_HOLDING;
    }

    protected class_243 getHandOffset(DeployerBlockEntity be, float partialTicks, class_2680 blockState) {
        float distance = getHandOffset(be, partialTicks);
        return class_243.method_24954(blockState.method_11654(FACING).method_62675()).method_1021(distance);
    }

    public static float getHandOffset(DeployerBlockEntity be, float partialTicks) {
        if (be.isVirtual())
            return be.animatedOffset.getValue(partialTicks);

        float progress = 0;
        int timerSpeed = be.getTimerSpeed();
        PartialModel handPose = getHandPose(be);

        if (be.state == State.EXPANDING) {
            progress = 1 - (be.timer - partialTicks * timerSpeed) / 1000f;
            if (be.fistBump)
                progress *= progress;
        }
        if (be.state == State.RETRACTING)
            progress = (be.timer - partialTicks * timerSpeed) / 1000f;
        float handLength = handPose == AllPartialModels.DEPLOYER_HAND_POINTING ? 0 : handPose == AllPartialModels.DEPLOYER_HAND_HOLDING ? 4 / 16f : 3 / 16f;
        return Math.min(class_3532.method_15363(progress, 0, 1) * (be.reach + handLength), 21 / 16f);
    }

    protected class_2680 getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft(KineticBlockEntityRenderer.getRotationAxisOf(be));
    }

    private static SuperByteBuffer transform(SuperByteBuffer buffer, class_2680 deployerState, boolean axisDirectionMatters) {
        class_2350 facing = deployerState.method_11654(FACING);

        float yRot = AngleHelper.horizontalAngle(facing);
        float xRot = facing == class_2350.field_11036 ? 270 : facing == class_2350.field_11033 ? 90 : 0;
        float zRot = axisDirectionMatters && (deployerState.method_11654(AXIS_ALONG_FIRST_COORDINATE) ^ facing.method_10166() == class_2350.class_2351.field_11051) ? 90 : 0;

        buffer.rotateCentered((float) ((yRot) / 180 * Math.PI), class_2350.field_11036);
        buffer.rotateCentered((float) ((xRot) / 180 * Math.PI), class_2350.field_11034);
        buffer.rotateCentered((float) ((zRot) / 180 * Math.PI), class_2350.field_11035);
        return buffer;
    }

    public static void renderInContraption(
        MovementContext context,
        VirtualRenderWorld renderWorld,
        ContraptionMatrices matrices,
        class_4597 buffer
    ) {
        class_4588 builder = buffer.getBuffer(class_1921.method_23577());
        class_2680 blockState = context.state;
        Mode mode = NBTHelper.readEnum(context.blockEntityData, "Mode", Mode.class);
        PartialModel handPose = getHandPose(mode);

        float speed = (float) context.getAnimationSpeed();
        if (context.contraption.stalled)
            speed = 0;

        SuperByteBuffer shaft = CachedBuffers.block(AllBlocks.SHAFT.method_9564());
        SuperByteBuffer pole = CachedBuffers.partial(AllPartialModels.DEPLOYER_POLE, blockState);
        SuperByteBuffer hand = CachedBuffers.partial(handPose, blockState);

        double factor;
        if (context.contraption.stalled || context.position == null || context.data.method_10545("StationaryTimer")) {
            factor = class_3532.method_15374(AnimationTickHolder.getRenderTime() * .5f) * .25f + .25f;
        } else {
            class_243 center = VecHelper.getCenterOf(class_2338.method_49638(context.position));
            double distance = context.position.method_1022(center);
            double nextDistance = context.position.method_1019(context.motion).method_1022(center);
            factor = .5f - class_3532.method_15350(class_3532.method_16436(AnimationTickHolder.getPartialTicks(), distance, nextDistance), 0, 1);
        }

        class_243 offset = class_243.method_24954(blockState.method_11654(FACING).method_62675()).method_1021(factor);

        class_4587 m = matrices.getModel();
        m.method_22903();

        m.method_22903();
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        if (context.state.method_26204() instanceof IRotate def) {
            axis = def.getRotationAxis(context.state);
        }

        float time = AnimationTickHolder.getRenderTime(context.world) / 20;
        float angle = (time * speed) % 360;

        TransformStack.of(m).center().rotateYDegrees(axis == class_2350.class_2351.field_11051 ? 90 : 0).rotateZDegrees(axis.method_10179() ? 90 : 0).uncenter();
        shaft.transform(m);
        shaft.rotateCentered(angle, class_2350.method_10156(class_2352.field_11056, class_2350.class_2351.field_11052));
        m.method_22909();

        if (!context.disabled)
            m.method_22904(offset.field_1352, offset.field_1351, offset.field_1350);
        pole.transform(m);
        hand.transform(m);

        transform(pole, blockState, true);
        transform(hand, blockState, false);

        shaft.light(class_761.method_23794(renderWorld, context.localPos)).useLevelLight(context.world, matrices.getWorld())
            .renderInto(matrices.getViewProjection(), builder);
        pole.light(class_761.method_23794(renderWorld, context.localPos)).useLevelLight(context.world, matrices.getWorld())
            .renderInto(matrices.getViewProjection(), builder);
        hand.light(class_761.method_23794(renderWorld, context.localPos)).useLevelLight(context.world, matrices.getWorld())
            .renderInto(matrices.getViewProjection(), builder);

        m.method_22909();
    }

    static PartialModel getHandPose(Mode mode) {
        return mode == Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : AllPartialModels.DEPLOYER_HAND_POINTING;
    }

}
