package com.zurrtum.create.client.content.kinetics.fan;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.fan.EncasedFanBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;

import static net.minecraft.class_2741.field_12525;

public class EncasedFanRenderer extends KineticBlockEntityRenderer<EncasedFanBlockEntity> {

    public EncasedFanRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(EncasedFanBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_1937 world = be.method_10997();
        if (VisualizationManager.supportsVisualization(world))
            return;

        class_2680 state = be.method_11010();
        class_2350 direction = state.method_11654(field_12525);
        class_4588 vb = buffer.getBuffer(class_1921.method_23579());

        class_2338 pos = be.method_11016();
        class_2350 opposite = direction.method_10153();
        int lightBehind = class_761.method_23794(world, pos.method_10093(opposite));
        int lightInFront = class_761.method_23794(world, pos.method_10093(direction));

        SuperByteBuffer shaftHalf = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state, opposite);
        SuperByteBuffer fanInner = CachedBuffers.partialFacing(AllPartialModels.ENCASED_FAN_INNER, state, opposite);

        float time = AnimationTickHolder.getRenderTime(world);
        float speed = be.getSpeed() * 5;
        if (speed > 0)
            speed = class_3532.method_15363(speed, 80, 64 * 20);
        if (speed < 0)
            speed = class_3532.method_15363(speed, -64 * 20, -80);
        float angle = (time * speed * 3 / 10f) % 360;
        angle = angle / 180f * (float) Math.PI;

        standardKineticRotationTransform(shaftHalf, be, lightBehind).renderInto(ms, vb);
        kineticRotationTransform(fanInner, be, direction.method_10166(), angle, lightInFront).renderInto(ms, vb);
    }

}
