package com.zurrtum.create.client.content.logistics.tableCloth;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;

public class TableClothRenderer extends SmartBlockEntityRenderer<TableClothBlockEntity> {
    public TableClothRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(
        TableClothBlockEntity blockEntity,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {
        super.renderSafe(blockEntity, partialTicks, ms, buffer, light, overlay);
        List<class_1799> stacks = blockEntity.getItemsForRender();
        float rotationInRadians = class_3532.field_29847 * (180 - blockEntity.facing.method_10144());

        if (blockEntity.isShop()) {
            CachedBuffers.partial(
                blockEntity.sideOccluded ? AllPartialModels.TABLE_CLOTH_PRICE_TOP : AllPartialModels.TABLE_CLOTH_PRICE_SIDE,
                blockEntity.method_11010()
            ).rotateCentered(rotationInRadians, class_2350.field_11036).light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(class_1921.method_23581()));
        }

        ms.method_22903();
        TransformStack.of(ms).rotateCentered(rotationInRadians, class_2350.field_11036);
        for (int i = 0; i < stacks.size(); i++) {
            class_1799 entry = stacks.get(i);
            ms.method_22903();
            ms.method_46416(0.5f, 3 / 16f, 0.5f);

            if (stacks.size() > 1) {
                ms.method_22907(class_7833.field_40716.rotationDegrees(i * (360f / stacks.size()) + 45f));
                ms.method_22904(0, i % 2 == 0 ? -0.005 : 0, 5 / 16f);
                ms.method_22907(class_7833.field_40716.rotationDegrees(-i * (360f / stacks.size()) - 45f));
            }

            DepotRenderer.renderItem(
                ms, buffer, light, class_4608.field_21444, entry, 0, null, class_243.method_24953(blockEntity.method_11016()), true, (stack, blockItem) -> {
                    if (!blockItem) {
                        stack.rotate(-rotationInRadians + class_3532.field_29844, class_2350.field_11036);
                    }
                }
            );
            ms.method_22909();
        }

        ms.method_22909();
    }
}
