package com.zurrtum.create.client.content.processing.basin;

import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour.TankSegment;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_811;

public class BasinRenderer extends SmartBlockEntityRenderer<BasinBlockEntity> {

    public BasinRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(BasinBlockEntity basin, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(basin, partialTicks, ms, buffer, light, overlay);

        float fluidLevel = renderFluids(basin, partialTicks, ms, buffer, light, overlay);
        float level = class_3532.method_15363(fluidLevel - .3f, .125f, .6f);

        ms.method_22903();

        class_2338 pos = basin.method_11016();
        ms.method_22904(.5, .2f, .5);
        TransformStack.of(ms).rotateYDegrees(basin.ingredientRotation.getValue(partialTicks));

        class_5819 r = class_5819.method_43049(pos.hashCode());
        class_243 baseVector = new class_243(.125, level, 0);

        class_1937 world = basin.method_10997();
        BasinInventory inv = basin.itemCapability;
        if (inv != null) {
            int size = inv.method_5439();
            int itemCount = 0;
            for (int slot = 0; slot < size; slot++)
                if (!inv.method_5438(slot).method_7960())
                    itemCount++;

            if (itemCount == 1)
                baseVector = new class_243(0, level, 0);

            float anglePartition = 360f / itemCount;
            for (int slot = 0; slot < size; slot++) {
                class_1799 stack = inv.method_5438(slot);
                if (stack.method_7960())
                    continue;

                ms.method_22903();

                if (fluidLevel > 0) {
                    ms.method_46416(
                        0,
                        (class_3532.method_15374(AnimationTickHolder.getRenderTime(world) / 12f + anglePartition * itemCount) + 1.5f) * 1 / 32f,
                        0
                    );
                }

                class_243 itemPosition = VecHelper.rotate(baseVector, anglePartition * itemCount, class_2351.field_11052);
                ms.method_22904(itemPosition.field_1352, itemPosition.field_1351, itemPosition.field_1350);
                TransformStack.of(ms).rotateYDegrees(anglePartition * itemCount + 35).rotateXDegrees(65);

                for (int i = 0; i <= stack.method_7947() / 8; i++) {
                    ms.method_22903();

                    class_243 vec = VecHelper.offsetRandomly(class_243.field_1353, r, 1 / 16f);

                    ms.method_22904(vec.field_1352, vec.field_1351, vec.field_1350);
                    renderItem(ms, buffer, light, overlay, stack);
                    ms.method_22909();
                }
                ms.method_22909();

                itemCount--;
            }
        }
        ms.method_22909();

        class_2680 blockState = basin.method_11010();
        if (!(blockState.method_26204() instanceof BasinBlock))
            return;
        class_2350 direction = blockState.method_11654(BasinBlock.FACING);
        if (direction == class_2350.field_11033)
            return;
        class_243 directionVec = class_243.method_24954(direction.method_62675());
        class_243 outVec = VecHelper.getCenterOf(class_2338.field_11176).method_1019(directionVec.method_1021(.55).method_1023(0, 1 / 2f, 0));

        boolean outToBasin = world.method_8320(basin.method_11016().method_10093(direction)).method_26204() instanceof BasinBlock;

        for (IntAttached<class_1799> intAttached : basin.visualizedOutputItems) {
            float progress = 1 - (intAttached.getFirst() - partialTicks) / BasinBlockEntity.OUTPUT_ANIMATION_TIME;

            if (!outToBasin && progress > .35f)
                continue;

            ms.method_22903();
            TransformStack.of(ms).translate(outVec).translate(new class_243(0, Math.max(-.55f, -(progress * progress * 2)), 0))
                .translate(directionVec.method_1021(progress * .5f)).rotateYDegrees(AngleHelper.horizontalAngle(direction))
                .rotateXDegrees(progress * 180);
            renderItem(ms, buffer, light, overlay, intAttached.getValue());
            ms.method_22909();
        }
    }

    protected void renderItem(class_4587 ms, class_4597 buffer, int light, int overlay, class_1799 stack) {
        class_310 mc = class_310.method_1551();
        mc.method_1480().method_23178(stack, class_811.field_4318, light, overlay, ms, buffer, mc.field_1687, 0);
    }

    protected float renderFluids(BasinBlockEntity basin, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        SmartFluidTankBehaviour inputFluids = basin.getBehaviour(SmartFluidTankBehaviour.INPUT);
        SmartFluidTankBehaviour outputFluids = basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT);
        SmartFluidTankBehaviour[] tanks = {inputFluids, outputFluids};
        float totalUnits = basin.getTotalFluidUnits(partialTicks);
        if (totalUnits < 1)
            return 0;

        float fluidLevel = class_3532.method_15363(totalUnits / (BucketFluidInventory.CAPACITY * 2), 0, 1);

        fluidLevel = 1 - ((1 - fluidLevel) * (1 - fluidLevel));

        float xMin = 2 / 16f;
        float xMax = 2 / 16f;
        final float yMin = 2 / 16f;
        final float yMax = yMin + 12 / 16f * fluidLevel;
        final float zMin = 2 / 16f;
        final float zMax = 14 / 16f;

        for (SmartFluidTankBehaviour behaviour : tanks) {
            if (behaviour == null)
                continue;
            for (TankSegment tankSegment : behaviour.getTanks()) {
                FluidStack renderedFluid = tankSegment.getRenderedFluid();
                if (renderedFluid.isEmpty())
                    continue;
                float units = tankSegment.getTotalUnits(partialTicks);
                if (units < 1)
                    continue;

                float partial = class_3532.method_15363(units / totalUnits, 0, 1);
                xMax += partial * 12 / 16f;
                FluidRenderHelper.renderFluidBox(renderedFluid, xMin, yMin, zMin, xMax, yMax, zMax, buffer, ms, light, false, false);

                xMin = xMax;
            }
        }

        return yMax;
    }

    @Override
    public int method_33893() {
        return 16;
    }

}
