package com.zurrtum.create.client.content.redstone.deskBell;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.redstone.deskBell.DeskBellBlock;
import com.zurrtum.create.content.redstone.deskBell.DeskBellBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class DeskBellRenderer extends SmartBlockEntityRenderer<DeskBellBlockEntity> {

    public DeskBellRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(
        DeskBellBlockEntity blockEntity,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {
        class_2680 blockState = blockEntity.method_11010();
        float p = blockEntity.animation.getValue(partialTicks);
        if (p < 0.004 && !blockState.method_61767(DeskBellBlock.POWERED, false))
            return;

        float f = (float) (1 - 4 * Math.pow((Math.max(p - 0.5, 0)) - 0.5, 2));
        float f2 = (float) (Math.pow(p, 1.25f));

        class_2350 facing = blockState.method_11654(DeskBellBlock.field_10927);

        CachedBuffers.partial(AllPartialModels.DESK_BELL_PLUNGER, blockState).center().rotateYDegrees(AngleHelper.horizontalAngle(facing))
            .rotateXDegrees(AngleHelper.verticalAngle(facing) + 90).uncenter().translate(0, f * -.75f / 16f, 0).light(light).overlay(overlay)
            .renderInto(ms, buffer.getBuffer(class_1921.method_23577()));

        CachedBuffers.partial(AllPartialModels.DESK_BELL_BELL, blockState).center().rotateYDegrees(AngleHelper.horizontalAngle(facing))
            .rotateXDegrees(AngleHelper.verticalAngle(facing) + 90).translate(0, -1 / 16, 0)
            .rotateXDegrees(f2 * 8 * class_3532.method_15374(p * class_3532.field_29844 * 4 + blockEntity.animationOffset))
            .rotateZDegrees(f2 * 8 * class_3532.method_15362(p * class_3532.field_29844 * 4 + blockEntity.animationOffset)).translate(0, 1 / 16, 0).scale(0.995f)
            .uncenter().light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
    }

}
