package com.zurrtum.create.client.content.redstone.link;

import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxRenderer;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_638;

public class LinkRenderer {

    public static void tick(class_310 mc) {
        class_239 target = mc.field_1765;
        if (target == null || !(target instanceof class_3965 result))
            return;

        class_638 world = mc.field_1687;
        class_2338 pos = result.method_17777();

        LinkBehaviour behaviour = BlockEntityBehaviour.get(world, pos, LinkBehaviour.TYPE);
        if (behaviour == null)
            return;

        class_2561 freq1 = CreateLang.translateDirect("logistics.firstFrequency");
        class_2561 freq2 = CreateLang.translateDirect("logistics.secondFrequency");

        for (boolean first : Iterate.trueAndFalse) {
            class_238 bb = new class_238(class_243.field_1353, class_243.field_1353).method_1014(.25f);
            class_2561 label = first ? freq1 : freq2;
            boolean hit = behaviour.testHit(first, target.method_17784());
            ValueBoxTransform transform = first ? behaviour.firstSlot : behaviour.secondSlot;

            ValueBox box = new ValueBox(label, bb, pos).passive(!hit);
            boolean empty = behaviour.getNetworkKey().get(first).getStack().method_7960();

            if (!empty)
                box.wideOutline();

            Outliner.getInstance().showOutline(Pair.of(first, pos), box.transform(transform)).highlightFace(result.method_17780());

            if (!hit)
                continue;

            List<class_5250> tip = new ArrayList<>();
            tip.add(label.method_27661());
            tip.add(CreateLang.translateDirect(empty ? "logistics.filter.click_to_set" : "logistics.filter.click_to_replace"));
            Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
        }
    }

    public static void renderOnBlockEntity(
        SmartBlockEntity be,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {

        if (be == null || be.method_11015())
            return;

        class_1297 cameraEntity = class_310.method_1551().field_1719;
        float max = AllConfigs.client().filterItemRenderDistance.getF();
        if (!be.isVirtual() && cameraEntity != null && cameraEntity.method_19538().method_1025(VecHelper.getCenterOf(be.method_11016())) > (max * max))
            return;

        LinkBehaviour behaviour = be.getBehaviour(LinkBehaviour.TYPE);
        if (behaviour == null || !behaviour.isLoad())
            return;

        for (boolean first : Iterate.trueAndFalse) {
            ValueBoxTransform transform = first ? behaviour.firstSlot : behaviour.secondSlot;
            class_1799 stack = first ? behaviour.getFirstStack() : behaviour.getLastStack();

            ms.method_22903();
            transform.transform(be.method_10997(), be.method_11016(), be.method_11010(), ms);
            ValueBoxRenderer.renderItemIntoValueBox(stack, ms, buffer, light, overlay);
            ms.method_22909();
        }

    }

}
