package com.zurrtum.create.client.content.schematics.table;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.schematics.client.ClientSchematicLoader;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.schematics.table.SchematicTableBlockEntity;
import com.zurrtum.create.content.schematics.table.SchematicTableMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.foundation.utility.CreatePaths;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_768;
import net.minecraft.class_8942;
import net.minecraft.class_9129;

import static com.zurrtum.create.Create.LOGGER;
import static com.zurrtum.create.client.foundation.gui.AllGuiTextures.PLAYER_INVENTORY;
import static com.zurrtum.create.client.foundation.gui.AllGuiTextures.SCHEMATIC_TABLE_PROGRESS;

public class SchematicTableScreen extends AbstractSimiContainerScreen<SchematicTableMenu> {

    private final class_2561 uploading = CreateLang.translateDirect("gui.schematicTable.uploading");
    private final class_2561 finished = CreateLang.translateDirect("gui.schematicTable.finished");
    private final class_2561 refresh = CreateLang.translateDirect("gui.schematicTable.refresh");
    private final class_2561 folder = CreateLang.translateDirect("gui.schematicTable.open_folder");
    private final class_2561 noSchematics = CreateLang.translateDirect("gui.schematicTable.noSchematics");
    private final class_2561 availableSchematicsTitle = CreateLang.translateDirect("gui.schematicTable.availableSchematics");

    protected AllGuiTextures background;

    private ScrollInput schematicsArea;
    private IconButton confirmButton;
    private IconButton folderButton;
    private IconButton refreshButton;
    private Label schematicsLabel;
    private ElementWidget renderedItem;

    private float progress;
    private float chasingProgress;
    private float lastChasingProgress;

    private List<class_768> extraAreas = Collections.emptyList();

    public SchematicTableScreen(SchematicTableMenu menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
        background = AllGuiTextures.SCHEMATIC_TABLE;
    }

    public static SchematicTableScreen create(
        class_310 mc,
        MenuType<SchematicTableBlockEntity> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        SchematicTableBlockEntity entity = getBlockEntity(mc, extraData);
        if (entity == null) {
            return null;
        }
        try (class_8942.class_11340 logging = new class_8942.class_11340(entity.method_71402(), LOGGER)) {
            class_11368 view = class_11352.method_71417(logging, extraData.method_56349(), extraData.method_10798());
            entity.readClient(view);
            return type.create(SchematicTableScreen::new, syncId, inventory, title, entity);
        }
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return method_19355(mouseX, mouseY).filter(element -> element.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)).isPresent();
    }

    @Override
    protected void method_25426() {
        setWindowSize(background.getWidth(), background.getHeight() + 4 + PLAYER_INVENTORY.getHeight());
        setWindowOffset(-11, 8);
        super.method_25426();

        Create.SCHEMATIC_SENDER.refresh();
        List<class_2561> availableSchematics = Create.SCHEMATIC_SENDER.getAvailableSchematics();

        int y = this.field_2800 + 2;

        schematicsLabel = new Label(field_2776 + 51, y + 26, class_5244.field_39003).withShadow();
        schematicsLabel.text = class_5244.field_39003;
        if (!availableSchematics.isEmpty()) {
            schematicsArea = new SelectionScrollInput(field_2776 + 45, y + 21, 139, 18).forOptions(availableSchematics)
                .titled(availableSchematicsTitle.method_27662()).writingTo(schematicsLabel);
            method_37063(schematicsArea);
            method_37063(schematicsLabel);
        }

        confirmButton = new IconButton(field_2776 + 44, y + 56, AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> {
            if (field_2797.canWrite() && schematicsArea != null) {
                ClientSchematicLoader schematicSender = Create.SCHEMATIC_SENDER;
                lastChasingProgress = chasingProgress = progress = 0;
                List<class_2561> availableSchematics1 = schematicSender.getAvailableSchematics();
                class_2561 schematic = availableSchematics1.get(schematicsArea.getState());
                schematicSender.startNewUpload(field_22787, schematic.getString());
            }
        });

        folderButton = new IconButton(field_2776 + 20, y + 21, AllIcons.I_OPEN_FOLDER);
        folderButton.withCallback(() -> {
            class_156.method_668().method_672(CreatePaths.SCHEMATICS_DIR.toFile());
        });
        folderButton.setToolTip(folder);
        refreshButton = new IconButton(field_2776 + 206, y + 21, AllIcons.I_REFRESH);
        refreshButton.withCallback(() -> {
            ClientSchematicLoader schematicSender = Create.SCHEMATIC_SENDER;
            schematicSender.refresh();
            List<class_2561> availableSchematics1 = schematicSender.getAvailableSchematics();
            method_37066(schematicsArea);

            if (!availableSchematics1.isEmpty()) {
                schematicsArea = new SelectionScrollInput(field_2776 + 45, this.field_2800 + 21, 139, 18).forOptions(availableSchematics1)
                    .titled(availableSchematicsTitle.method_27662()).writingTo(schematicsLabel);
                schematicsArea.onChanged();
                method_37063(schematicsArea);
            } else {
                schematicsArea = null;
                schematicsLabel.text = class_5244.field_39003;
            }
        });
        refreshButton.setToolTip(refresh);

        method_37063(confirmButton);
        method_37063(folderButton);
        method_37063(refreshButton);

        extraAreas = ImmutableList.of(
            new class_768(field_2776 + background.getWidth(), y + background.getHeight() - 40, 48, 48),
            new class_768(refreshButton.method_46426(), refreshButton.method_46427(), refreshButton.method_25368(), refreshButton.method_25364())
        );

        renderedItem = new ElementWidget(
            field_2776 + background.getWidth(),
            this.field_2800 + background.getHeight() - 40
        ).showingElement(GuiGameElement.of(AllItems.SCHEMATIC_TABLE.method_7854()).scale(3));
        method_37063(renderedItem);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = getLeftOfCentered(PLAYER_INVENTORY.getWidth());
        int invY = field_2800 + background.getHeight() + 4;
        renderPlayerInventory(graphics, invX, invY);

        background.render(graphics, field_2776, field_2800);

        class_2561 titleText;
        if (field_2797.contentHolder.isUploading)
            titleText = uploading;
        else if (field_2797.method_7611(1).method_7681())
            titleText = finished;
        else
            titleText = field_22785;

        graphics.method_51439(field_22793, titleText, field_2776 + (background.getWidth() - 8 - field_22793.method_27525(titleText)) / 2, field_2800 + 4, 0xFF505050, false);

        if (schematicsArea == null)
            graphics.method_51439(field_22793, noSchematics, field_2776 + 54, field_2800 + 28, 0xFFD3D3D3, true);

        int width = (int) (SCHEMATIC_TABLE_PROGRESS.getWidth() * class_3532.method_16439(partialTicks, lastChasingProgress, chasingProgress));
        int height = SCHEMATIC_TABLE_PROGRESS.getHeight();
        graphics.method_25290(
            class_10799.field_56883,
            SCHEMATIC_TABLE_PROGRESS.location,
            field_2776 + 70,
            field_2800 + 59,
            SCHEMATIC_TABLE_PROGRESS.getStartX(),
            SCHEMATIC_TABLE_PROGRESS.getStartY(),
            width,
            height,
            256,
            256
        );
    }

    @Override
    protected void method_37432() {
        super.method_37432();

        boolean finished = field_2797.method_7611(1).method_7681();

        if (field_2797.contentHolder.isUploading || finished) {
            if (finished) {
                chasingProgress = lastChasingProgress = progress = 1;
            } else {
                lastChasingProgress = chasingProgress;
                progress = field_2797.contentHolder.uploadingProgress;
                chasingProgress += (progress - chasingProgress) * .5f;
            }
            confirmButton.field_22763 = false;

            if (schematicsLabel != null) {
                schematicsLabel.colored(0xFFCCDDFF);
                String uploadingSchematic = field_2797.contentHolder.uploadingSchematic;
                if (uploadingSchematic == null) {
                    schematicsLabel.text = null;
                } else {
                    schematicsLabel.text = class_2561.method_43470(uploadingSchematic);
                }
            }
            if (schematicsArea != null)
                schematicsArea.field_22764 = false;

        } else {
            progress = 0;
            chasingProgress = lastChasingProgress = 0;
            confirmButton.field_22763 = true;

            if (schematicsLabel != null)
                schematicsLabel.colored(0xFFFFFFFF);
            if (schematicsArea != null) {
                schematicsArea.writingTo(schematicsLabel);
                schematicsArea.field_22764 = true;
            }
        }
    }

    @Override
    public List<class_768> getExtraAreas() {
        return extraAreas;
    }

}