package com.zurrtum.create.client.content.trains.display;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.content.trains.display.FlapDisplayBlock;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_377;
import net.minecraft.class_379;
import net.minecraft.class_382;
import net.minecraft.class_384;
import net.minecraft.class_4587;
import net.minecraft.class_4587.class_4665;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4597.class_4598;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5251;
import net.minecraft.class_5614;
import net.minecraft.client.font.*;
import org.joml.Matrix4f;

import java.util.List;

public class FlapDisplayRenderer extends KineticBlockEntityRenderer<FlapDisplayBlockEntity> {

    public FlapDisplayRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(FlapDisplayBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);

        class_327 fontRenderer = class_310.method_1551().field_1772;
        class_377 fontSet = fontRenderer.method_27526(class_2583.field_24359);

        float scale = 1 / 32f;

        if (!be.isController)
            return;

        List<FlapDisplayLayout> lines = be.getLines();

        ms.method_22903();
        TransformStack.of(ms).center().rotateYDegrees(AngleHelper.horizontalAngle(be.method_11010().method_11654(FlapDisplayBlock.HORIZONTAL_FACING)))
            .uncenter().translate(0, 0, -3 / 16f);

        ms.method_46416(0, 1, 1);
        ms.method_22905(scale, scale, scale);
        ms.method_22905(1, -1, 1);
        ms.method_46416(0, 0, 1 / 2f);

        for (int j = 0; j < lines.size(); j++) {
            List<FlapDisplaySection> line = lines.get(j).getSections();
            int color = getLineColor(be, j);
            ms.method_22903();

            float w = 0;
            for (FlapDisplaySection section : line)
                w += section.getSize() + (section.hasGap ? 8 : 1);
            ms.method_46416(be.xSize * 16 - w / 2 + 1, 4.5f, 0);

            class_4665 transform = ms.method_23760();
            FlapDisplayRenderOutput renderOutput = new FlapDisplayRenderOutput(
                fontSet,
                buffer,
                color,
                transform.method_23761(),
                light,
                j,
                !be.isSpeedRequirementFulfilled(),
                be.method_10997(),
                be.isLineGlowing(j)
            );

            for (int i = 0; i < line.size(); i++) {
                FlapDisplaySection section = line.get(i);
                renderOutput.nextSection(section);
                int ticks = AnimationTickHolder.getTicks(be.method_10997());
                String text = section.renderCharsIndividually() || !section.spinning[0] ? section.text : section.cyclingOptions[((ticks / 3) + i * 13) % section.cyclingOptions.length];
                class_5223.method_27479(text, class_2583.field_24360, renderOutput);
                ms.method_46416(section.getSize() + (section.hasGap ? 8 : 1), 0, 0);
            }

            if (buffer instanceof class_4598 bs) {
                class_382 texturedglyph = fontSet.method_22943();
                bs.method_22994(texturedglyph.method_24045(class_327.class_6415.field_33993));
            }

            ms.method_22909();
            ms.method_46416(0, 16, 0);
        }

        ms.method_22909();
    }

    public static int getLineColor(FlapDisplayBlockEntity be, int line) {
        class_1767 color = be.colour[line];
        return color == null ? 0xFF_D3C6BA : DyeHelper.getDyeColors(color).getFirst() | 0xFF_000000;
    }

    static class FlapDisplayRenderOutput implements class_5224 {
        final class_377 fontSet;
        final class_4597 bufferSource;
        final int color;
        final int r, g, b, a;
        final Matrix4f pose;
        final int light;
        final boolean paused;

        FlapDisplaySection section;
        float x;
        private int lineIndex;
        private class_1937 level;

        public FlapDisplayRenderOutput(
            class_377 fontSet,
            class_4597 buffer,
            int color,
            Matrix4f pose,
            int light,
            int lineIndex,
            boolean paused,
            class_1937 level,
            boolean glowing
        ) {
            this.fontSet = fontSet;
            this.bufferSource = buffer;
            this.lineIndex = lineIndex;
            this.level = level;
            this.a = glowing ? 0xF8000000 : 0xD8000000;
            this.r = color >> 16 & 255;
            this.g = color >> 8 & 255;
            this.b = color & 255;
            this.color = color;
            this.pose = pose;
            this.light = glowing ? 0xf000f0 : light;
            this.paused = paused;
        }

        public void nextSection(FlapDisplaySection section) {
            this.section = section;
            x = 0;
        }

        public boolean accept(int charIndex, class_2583 style, int glyph) {
            int ticks = paused ? 0 : AnimationTickHolder.getTicks(level);
            float time = paused ? 0 : AnimationTickHolder.getRenderTime(level);
            class_5251 textcolor = style.method_10973();
            boolean canDim = textcolor == null;
            boolean dim = false;

            if (section.renderCharsIndividually() && section.spinning[Math.min(charIndex, section.spinning.length)]) {
                float speed = section.spinningTicks > 5 && section.spinningTicks < 20 ? 1.75f : 2.5f;
                float cycle = (time / speed) + charIndex * 16.83f + lineIndex * 0.75f;
                float partial = cycle % 1;
                char cyclingGlyph = section.cyclingOptions[((int) cycle) % section.cyclingOptions.length].charAt(0);
                glyph = paused ? cyclingGlyph : partial > 1 / 2f ? partial > 3 / 4f ? '_' : '-' : cyclingGlyph;
                if (canDim)
                    dim = true;
            }

            class_379 glyphinfo = fontSet.method_2011(glyph, false);
            float glyphWidth = glyphinfo.method_16798(false);

            if (!section.renderCharsIndividually() && section.spinning[0]) {
                glyph = ticks % 3 == 0 ? glyphWidth == 6 ? '-' : glyphWidth == 1 ? '\'' : glyph : glyph;
                glyph = ticks % 3 == 2 ? glyphWidth == 6 ? '_' : glyphWidth == 1 ? '.' : glyph : glyph;
                if (canDim && ticks % 3 != 1)
                    dim = true;
            }

            class_382 bakedglyph = style.method_10987() && glyph != 32 ? fontSet.method_2013(glyphinfo) : fontSet.method_2014(glyph);

            int drawColor = a;
            if (textcolor != null) {
                drawColor |= textcolor.method_27716();
            } else if (dim) {
                drawColor |= (r * 0xC0 >> 8 << 16) | (g * 0xC0 >> 8 << 8) | (b * 0xC0 >> 8);
            } else {
                drawColor |= color;
            }

            float standardWidth = section.wideFlaps ? FlapDisplaySection.WIDE_MONOSPACE : FlapDisplaySection.MONOSPACE;

            if (section.renderCharsIndividually())
                x += (standardWidth - glyphWidth) / 2f;

            if (isNotEmpty(bakedglyph)) {
                class_4588 vertexconsumer = bufferSource.getBuffer(renderTypeOf(bakedglyph));
                bakedglyph.method_2025(style.method_10966(), x, 0, 0, pose, vertexconsumer, drawColor, false, light);
            }

            if (section.renderCharsIndividually())
                x += standardWidth - (standardWidth - glyphWidth) / 2f;
            else
                x += glyphWidth;

            return true;
        }

        public float finish(int bgColor) {
            if (bgColor == 0)
                return x;

            class_382 bakedglyph = fontSet.method_22943();
            class_4588 vertexconsumer = bufferSource.getBuffer(renderTypeOf(bakedglyph));
            bakedglyph.method_22944(
                new class_382.class_328(-1f, -2f, section.getSize(), 9f, 0.01f, bgColor, 0, 0),
                pose,
                vertexconsumer,
                light,
                true
            );

            return x;
        }

        private class_1921 renderTypeOf(class_382 bakedglyph) {
            return bakedglyph.method_24045(class_327.class_6415.field_33993);
        }

        private boolean isNotEmpty(class_382 bakedglyph) {
            return !(bakedglyph instanceof class_384);
        }

    }

    @Override
    protected SuperByteBuffer getRotatedModel(FlapDisplayBlockEntity be, class_2680 state) {
        return CachedBuffers.partialFacingVertical(AllPartialModels.SHAFTLESS_COGWHEEL, state, state.method_11654(FlapDisplayBlock.HORIZONTAL_FACING));
    }

    @Override
    public boolean method_3563() {
        //        return be.isController;
        return true;
    }

}
