package com.zurrtum.create.client.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.trains.schedule.condition.FluidThresholdCondition;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class FluidThresholdConditionRender extends CargoThresholdConditionRender<FluidThresholdCondition> {
    @Override
    protected class_2561 getUnit(FluidThresholdCondition input) {
        return class_2561.method_43470("b");
    }

    @Override
    protected class_1799 getIcon(FluidThresholdCondition input) {
        return input.compareStack.item();
    }

    private FluidStack loadFluid(FluidThresholdCondition input) {
        return input.compareStack.fluid(class_310.method_1551().field_1687);
    }

    @Override
    public List<class_2561> getTitleAs(FluidThresholdCondition input, String type) {
        return ImmutableList.of(
            CreateLang.translateDirect(
                "schedule.condition.threshold.train_holds",
                CreateLang.translateDirect("schedule.condition.threshold." + Lang.asId(input.getOperator().name()))
            ), CreateLang.translateDirect(
                "schedule.condition.threshold.x_units_of_item",
                input.getThreshold(),
                CreateLang.translateDirect("schedule.condition.threshold.buckets"),
                input.compareStack.isEmpty() ? CreateLang.translateDirect("schedule.condition.threshold.anything") : input.compareStack.isFilterItem() ? CreateLang.translateDirect(
                    "schedule.condition.threshold.matching_content") : loadFluid(input).getName()
            ).method_27692(class_124.field_1062)
        );
    }

    @Override
    public void setItem(FluidThresholdCondition input, int slot, class_1799 stack) {
        input.compareStack = FilterItemStack.of(stack);
    }

    @Override
    public class_1799 getItem(FluidThresholdCondition input, int slot) {
        return input.compareStack.item();
    }

    @Override
    public void initConfigurationWidgets(FluidThresholdCondition input, ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(input, builder);
        builder.addSelectionScrollInput(
            71, 50, (i, l) -> {
                i.forOptions(ImmutableList.of(CreateLang.translateDirect("schedule.condition.threshold.buckets"))).titled(null);
            }, "Measure"
        );
    }
}
