package com.zurrtum.create.client.content.trains.schedule.hat;

import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import com.zurrtum.create.Create;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1473;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4013;
import net.minecraft.class_7654;
import net.minecraft.class_7923;

public class TrainHatInfoReloadListener {

    private static final Map<class_1299<?>, TrainHatInfo> ENTITY_INFO_MAP = new HashMap<>();
    public static final String HAT_INFO_DIRECTORY = "train_hat_info";
    public static final class_4013 LISTENER = TrainHatInfoReloadListener::registerOffsetOverrides;
    public static final TrainHatInfo DEFAULT = new TrainHatInfo("", 0, class_243.field_1353, 1.0F);

    private static void registerOffsetOverrides(class_3300 manager) {
        ENTITY_INFO_MAP.clear();

        class_7654 converter = class_7654.method_45114(HAT_INFO_DIRECTORY);
        converter.method_45113(manager).forEach((location, resource) -> {
            String[] splitPath = location.method_12832().split("/");
            class_2960 entityName = class_2960.method_60655(location.method_12836(), splitPath[splitPath.length - 1].replace(".json", ""));
            if (!class_7923.field_41177.method_10250(entityName)) {
                Create.LOGGER.error("Failed to load train hat info for entity {} as it does not exist.", entityName);
                return;
            }

            try (BufferedReader reader = resource.method_43039()) {
                JsonObject json = class_3518.method_15255(reader);
                ENTITY_INFO_MAP.put(
                    class_7923.field_41177.method_63535(entityName),
                    TrainHatInfo.CODEC.parse(JsonOps.INSTANCE, json).resultOrPartial(Create.LOGGER::error).orElseThrow()
                );
            } catch (Exception e) {
                Create.LOGGER.error("Failed to read train hat info for entity {}!", entityName, e);
            }
        });
        Create.LOGGER.info("Loaded {} train hat configurations.", ENTITY_INFO_MAP.size());
    }

    public static TrainHatInfo getHatInfoFor(class_1297 entity) {
        // Manual override for snow golems, they are a special case when they have a pumpkin on their head
        if (entity instanceof class_1473 snowGolem && snowGolem.method_6643()) {
            return new TrainHatInfo("", 0, new class_243(0.0F, -3.0F, 0.0F), 1.18F);
        }

        return ENTITY_INFO_MAP.getOrDefault(entity.method_5864(), DEFAULT);
    }
}
