package com.zurrtum.create.client.content.trains.station;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrainIcons;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.content.decoration.slidingDoor.SlidingDoorRenderer;
import com.zurrtum.create.client.content.trains.entity.TrainIcon;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControl;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.infrastructure.packet.c2s.StationEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrainEditPacket;
import org.joml.Matrix3x2fStack;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class StationScreen extends AbstractStationScreen {

    private class_342 nameBox;
    private class_342 trainNameBox;
    private IconButton newTrainButton;
    private IconButton disassembleTrainButton;
    private IconButton dropScheduleButton;

    private int leavingAnimation;
    private LerpedFloat trainPosition;
    private DoorControl doorControl;

    private ScrollInput colorTypeScroll;
    private int messedWithColors;

    private boolean switchingToAssemblyMode;

    public StationScreen(StationBlockEntity be, GlobalStation station) {
        super(be, station);
        background = AllGuiTextures.STATION;
        leavingAnimation = 0;
        trainPosition = LerpedFloat.linear().startWithValue(0);
        switchingToAssemblyMode = false;
        doorControl = be.doorControls.mode;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int x = guiLeft;
        int y = guiTop;

        Consumer<String> onTextChanged;

        onTextChanged = s -> nameBox.method_46421(nameBoxX(s, nameBox));
        nameBox = new class_342(
            new NoShadowFontWrapper(field_22793),
            x + 23,
            y + 4,
            background.getWidth() - 20,
            10,
            class_2561.method_43470(station.name)
        );
        nameBox.method_1858(false);
        nameBox.method_1880(25);
        nameBox.method_1868(0xFF592424);
        nameBox.method_1852(station.name);
        nameBox.method_25365(false);
        nameBox.method_25402(0, 0, 0);
        nameBox.method_1863(onTextChanged);
        nameBox.method_46421(nameBoxX(nameBox.method_1882(), nameBox));
        method_37063(nameBox);

        Runnable assemblyCallback = () -> {
            switchingToAssemblyMode = true;
            field_22787.method_1507(new AssemblyScreen(blockEntity, station));
        };

        newTrainButton = new WideIconButton(x + 84, y + 65, AllGuiTextures.I_NEW_TRAIN);
        newTrainButton.withCallback(assemblyCallback);
        method_37063(newTrainButton);

        disassembleTrainButton = new WideIconButton(x + 94, y + 65, AllGuiTextures.I_DISASSEMBLE_TRAIN);
        disassembleTrainButton.field_22763 = false;
        disassembleTrainButton.field_22764 = false;
        disassembleTrainButton.withCallback(assemblyCallback);
        method_37063(disassembleTrainButton);

        dropScheduleButton = new IconButton(x + 73, y + 65, AllIcons.I_VIEW_SCHEDULE);
        dropScheduleButton.field_22763 = false;
        dropScheduleButton.field_22764 = false;
        dropScheduleButton.withCallback(() -> field_22787.field_1724.field_3944.method_52787(StationEditPacket.dropSchedule(blockEntity.method_11016())));
        method_37063(dropScheduleButton);

        colorTypeScroll = new ScrollInput(x + 166, y + 17, 22, 14).titled(CreateLang.translateDirect("station.train_map_color"));
        colorTypeScroll.withRange(0, 16);
        colorTypeScroll.withStepFunction(ctx -> colorTypeScroll.standardStep().apply(ctx));
        colorTypeScroll.calling(s -> {
            Train train = displayedTrain.get();
            if (train != null) {
                train.mapColorIndex = s;
                messedWithColors = 10;
            }
        });
        colorTypeScroll.field_22763 = colorTypeScroll.field_22764 = false;
        method_37063(colorTypeScroll);

        onTextChanged = s -> trainNameBox.method_46421(nameBoxX(s, trainNameBox));
        trainNameBox = new class_342(field_22793, x + 23, y + 47, background.getWidth() - 75, 10, class_5244.field_39003);
        trainNameBox.method_1858(false);
        trainNameBox.method_1880(35);
        trainNameBox.method_1868(0xFFC6C6C6);
        trainNameBox.method_25365(false);
        trainNameBox.method_25402(0, 0, 0);
        trainNameBox.method_1863(onTextChanged);
        trainNameBox.field_22763 = false;

        tickTrainDisplay();

        Pair<ScrollInput, Label> doorControlWidgets = SlidingDoorRenderer.createWidget(
            field_22787,
            x + 35,
            y + 102,
            mode -> doorControl = mode,
            doorControl
        );
        method_37063(doorControlWidgets.getFirst());
        method_37063(doorControlWidgets.getSecond());
    }

    @Override
    public void method_25393() {
        tickTrainDisplay();
        if (method_25399() != nameBox) {
            nameBox.method_1875(nameBox.method_1882().length());
            nameBox.method_1884(nameBox.method_1881());
        }
        if (method_25399() != trainNameBox || trainNameBox.field_22763 == false) {
            trainNameBox.method_1875(trainNameBox.method_1882().length());
            trainNameBox.method_1884(trainNameBox.method_1881());
        }

        if (messedWithColors > 0) {
            messedWithColors--;
            if (messedWithColors == 0)
                syncTrainNameAndColor();
        }

        super.method_25393();

        updateAssemblyTooltip(blockEntity.edgePoint.isOnCurve() ? "no_assembly_curve" : !blockEntity.edgePoint.isOrthogonal() ? "no_assembly_diagonal" : trainPresent() && !blockEntity.trainCanDisassemble ? "train_not_aligned" : null);
    }

    private void tickTrainDisplay() {
        Train train = displayedTrain.get();

        if (train == null) {
            if (trainNameBox.field_22763) {
                trainNameBox.field_22763 = false;
                method_37066(trainNameBox);
            }

            leavingAnimation = 0;
            newTrainButton.field_22763 = blockEntity.edgePoint.isOrthogonal();
            newTrainButton.field_22764 = true;
            colorTypeScroll.field_22764 = false;
            colorTypeScroll.field_22763 = false;
            Train imminentTrain = getImminent();

            if (imminentTrain != null) {
                displayedTrain = new WeakReference<>(imminentTrain);
                newTrainButton.field_22763 = false;
                newTrainButton.field_22764 = false;
                disassembleTrainButton.field_22763 = false;
                disassembleTrainButton.field_22764 = true;
                dropScheduleButton.field_22763 = blockEntity.trainHasSchedule;
                dropScheduleButton.field_22764 = true;
                if (mapModsPresent()) {
                    colorTypeScroll.setState(imminentTrain.mapColorIndex);
                    colorTypeScroll.field_22764 = true;
                    colorTypeScroll.field_22763 = true;
                }
                trainNameBox.field_22763 = true;
                trainNameBox.method_1852(imminentTrain.name.getString());
                trainNameBox.method_46421(nameBoxX(trainNameBox.method_1882(), trainNameBox));
                method_37063(trainNameBox);

                int trainIconWidth = getTrainIconWidth(imminentTrain);
                int targetPos = background.getWidth() / 2 - trainIconWidth / 2;
                if (trainIconWidth > 130)
                    targetPos -= trainIconWidth - 130;
                float f = (float) (imminentTrain.navigation.distanceToDestination / 15f);
                if (trainPresent())
                    f = 0;
                trainPosition.startWithValue(targetPos - (targetPos + 5) * f);
            }
            return;
        }

        int trainIconWidth = getTrainIconWidth(train);
        int targetPos = background.getWidth() / 2 - trainIconWidth / 2;
        if (trainIconWidth > 130)
            targetPos -= trainIconWidth - 130;

        if (leavingAnimation > 0) {
            colorTypeScroll.field_22764 = false;
            colorTypeScroll.field_22763 = false;
            disassembleTrainButton.field_22763 = false;
            float f = 1 - (leavingAnimation / 80f);
            trainPosition.setValue(targetPos + f * f * f * (background.getWidth() - targetPos + 5));
            leavingAnimation--;
            if (leavingAnimation > 0)
                return;

            displayedTrain = new WeakReference<>(null);
            disassembleTrainButton.field_22764 = false;
            dropScheduleButton.field_22763 = false;
            dropScheduleButton.field_22764 = false;
            return;
        }

        if (getImminent() != train) {
            leavingAnimation = 80;
            return;
        }

        boolean trainAtStation = trainPresent();
        disassembleTrainButton.field_22763 = trainAtStation && blockEntity.trainCanDisassemble && blockEntity.edgePoint.isOrthogonal();
        dropScheduleButton.field_22763 = blockEntity.trainHasSchedule;

        if (blockEntity.trainHasSchedule)
            dropScheduleButton.setToolTip(CreateLang.translateDirect(blockEntity.trainHasAutoSchedule ? "station.remove_auto_schedule" : "station.remove_schedule"));
        else
            dropScheduleButton.getToolTip().clear();

        float f = trainAtStation ? 0 : (float) (train.navigation.distanceToDestination / 30f);
        trainPosition.setValue(targetPos - (targetPos + trainIconWidth) * f);
    }

    private int nameBoxX(String s, class_342 nameBox) {
        return guiLeft + background.getWidth() / 2 - (Math.min(field_22793.method_1727(s), nameBox.method_25368()) + 10) / 2;
    }

    private void updateAssemblyTooltip(String key) {
        if (key == null) {
            disassembleTrainButton.setToolTip(CreateLang.translateDirect("station.disassemble_train"));
            newTrainButton.setToolTip(CreateLang.translateDirect("station.create_train"));
            return;
        }
        for (IconButton ib : new IconButton[]{disassembleTrainButton, newTrainButton}) {
            List<class_2561> toolTip = ib.getToolTip();
            toolTip.clear();
            toolTip.add(CreateLang.translateDirect("station." + key).method_27692(class_124.field_1080));
            toolTip.add(CreateLang.translateDirect("station." + key + "_1").method_27692(class_124.field_1080));
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        int x = guiLeft;
        int y = guiTop;

        String text = nameBox.method_1882();

        if (!nameBox.method_25370())
            AllGuiTextures.STATION_EDIT_NAME.render(graphics, nameBoxX(text, nameBox) + field_22793.method_1727(text) + 5, y + 1);

        graphics.method_51427(AllItems.TRAIN_DOOR.method_7854(), x + 14, y + 103);

        Train train = displayedTrain.get();
        if (train == null) {
            class_5250 header = CreateLang.translateDirect("station.idle");
            graphics.method_51439(field_22793, header, x + 97 - field_22793.method_27525(header) / 2, y + 47, 0xFF7A7A7A, false);
            return;
        }

        float position = trainPosition.getValue(partialTicks);

        Matrix3x2fStack ms = graphics.method_51448();
        ms.pushMatrix();
        //        RenderSystem.enableBlend();
        ms.translate(position, 0);
        TrainIcon icon = AllTrainIcons.byType(train.icon);
        int offset = 0;

        List<Carriage> carriages = train.carriages;
        for (int i = carriages.size() - 1; i > 0; i--) {
            //            RenderSystem.setShaderColor(
            //                1,
            //                1,
            //                1,
            //                Math.min(1f, Math.min((position + offset - 10) / 30f, (background.getWidth() - 40 - position - offset) / 30f))
            //            );
            Carriage carriage = carriages.get(blockEntity.trainBackwards ? carriages.size() - i - 1 : i);
            offset += icon.render(carriage.bogeySpacing, graphics, x + offset, y + 20) + 1;
        }
        //
        //        RenderSystem.setShaderColor(
        //            1,
        //            1,
        //            1,
        //            Math.min(1f, Math.min((position + offset - 10) / 30f, (background.getWidth() - 40 - position - offset) / 30f))
        //        );
        offset += icon.render(TrainIcon.ENGINE, graphics, x + offset, y + 20);
        //        RenderSystem.disableBlend();
        ms.popMatrix();
        //
        //        RenderSystem.setShaderColor(1, 1, 1, 1);

        AllGuiTextures.STATION_TEXTBOX_TOP.render(graphics, x + 21, y + 42);
        UIRenderHelper.drawStretched(graphics, x + 21, y + 60, 150, 26, AllGuiTextures.STATION_TEXTBOX_MIDDLE);
        AllGuiTextures.STATION_TEXTBOX_BOTTOM.render(graphics, x + 21, y + 86);

        ms.pushMatrix();
        ms.translate(class_3532.method_15363(position + offset - 13, 25, 159), 0);
        AllGuiTextures.STATION_TEXTBOX_SPEECH.render(graphics, x, y + 38);
        ms.popMatrix();

        text = trainNameBox.method_1882();
        if (!trainNameBox.method_25370()) {
            int buttonX = nameBoxX(text, trainNameBox) + field_22793.method_1727(text) + 5;
            AllGuiTextures.STATION_EDIT_TRAIN_NAME.render(graphics, Math.min(buttonX, guiLeft + 156), y + 44);
            if (field_22793.method_1727(text) > trainNameBox.method_25368())
                graphics.method_51433(field_22793, "...", guiLeft + 26, guiTop + 47, 0xffa6a6a6, true);
        }

        if (!mapModsPresent())
            return;

        AllGuiTextures sprite = AllGuiTextures.TRAINMAP_SPRITES;
        sprite.bind();
        int trainColorIndex = colorTypeScroll.getState();
        int colorRow = trainColorIndex / 4;
        int colorCol = trainColorIndex % 4;
        int rotation = (AnimationTickHolder.getTicks() / 5) % 8;

        for (int slice = 0; slice < 3; slice++) {
            int row = slice == 0 ? 1 : slice == 2 ? 2 : 3;
            int col = rotation;
            int positionX = colorTypeScroll.method_46426() + 4;
            int positionY = colorTypeScroll.method_46427() - 1;
            int sheetX = col * 16 + colorCol * 128;
            int sheetY = row * 16 + colorRow * 64;

            graphics.method_25290(
                class_10799.field_56883,
                sprite.location,
                positionX,
                positionY,
                sheetX,
                sheetY,
                16,
                16,
                sprite.getWidth(),
                sprite.getHeight()
            );
        }
    }

    public boolean mapModsPresent() {
        //TODO
        //        return Mods.FTBCHUNKS.isLoaded() || Mods.JOURNEYMAP.isLoaded() || Mods.XAEROWORLDMAP.isLoaded();
        return false;
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (!nameBox.method_25370() && pMouseY > guiTop && pMouseY < guiTop + 14 && pMouseX > guiLeft && pMouseX < guiLeft + background.getWidth()) {
            nameBox.method_25365(true);
            nameBox.method_1884(0);
            method_25395(nameBox);
            return true;
        }
        if (trainNameBox.field_22763 && !trainNameBox.method_25370() && pMouseY > guiTop + 45 && pMouseY < guiTop + 58 && pMouseX > guiLeft + 25 && pMouseX < guiLeft + 168) {
            trainNameBox.method_25365(true);
            trainNameBox.method_1884(0);
            method_25395(trainNameBox);
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    @Override
    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        boolean hitEnter = method_25399() instanceof class_342 && (pKeyCode == class_3675.field_31957 || pKeyCode == class_3675.field_31980);

        if (hitEnter && nameBox.method_25370()) {
            nameBox.method_25365(false);
            syncStationName();
            return true;
        }

        if (hitEnter && trainNameBox.method_25370()) {
            trainNameBox.method_25365(false);
            syncTrainNameAndColor();
            return true;
        }

        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    private void syncTrainNameAndColor() {
        Train train = displayedTrain.get();
        if (train != null && !trainNameBox.method_1882().equals(train.name.getString()))
            field_22787.field_1724.field_3944.method_52787(new TrainEditPacket(train.id, trainNameBox.method_1882(), train.icon.id(), train.mapColorIndex));
    }

    private void syncStationName() {
        if (!nameBox.method_1882().equals(station.name))
            field_22787.field_1724.field_3944.method_52787(StationEditPacket.configure(blockEntity.method_11016(), false, nameBox.method_1882(), doorControl));
    }

    @Override
    public void method_25432() {
        super.method_25432();
        if (nameBox == null || trainNameBox == null)
            return;
        field_22787.field_1724.field_3944.method_52787(StationEditPacket.configure(
            blockEntity.method_11016(),
            switchingToAssemblyMode,
            nameBox.method_1882(),
            doorControl
        ));
        Train train = displayedTrain.get();
        if (train == null)
            return;
        if (!switchingToAssemblyMode)
            field_22787.field_1724.field_3944.method_52787(new TrainEditPacket(train.id, trainNameBox.method_1882(), train.icon.id(), train.mapColorIndex));
        else
            blockEntity.imminentTrain = null;
    }

    @Override
    protected PartialModel getFlag(float partialTicks) {
        return blockEntity.flag.getValue(partialTicks) > 0.75f ? AllPartialModels.STATION_ON : AllPartialModels.STATION_OFF;
    }

}