package com.zurrtum.create.client.flywheel.backend.engine.instancing;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.backend.engine.GroupKey;
import com.zurrtum.create.client.flywheel.backend.engine.MeshPool;
import com.zurrtum.create.client.flywheel.backend.gl.TextureBuffer;

public class InstancedDraw {
    public final GroupKey<?> groupKey;
    private final InstancedInstancer<?> instancer;
    private final MeshPool.PooledMesh mesh;
    private final Material material;
    private final int bias;
    private final int indexOfMeshInModel;

    private boolean deleted;

    public InstancedDraw(
        InstancedInstancer<?> instancer,
        MeshPool.PooledMesh mesh,
        GroupKey<?> groupKey,
        Material material,
        int bias,
        int indexOfMeshInModel
    ) {
        this.instancer = instancer;
        this.mesh = mesh;
        this.groupKey = groupKey;
        this.material = material;
        this.bias = bias;
        this.indexOfMeshInModel = indexOfMeshInModel;

        mesh.acquire();
    }

    public int bias() {
        return bias;
    }

    public int indexOfMeshInModel() {
        return indexOfMeshInModel;
    }

    public Material material() {
        return material;
    }

    public boolean deleted() {
        return deleted;
    }

    public MeshPool.PooledMesh mesh() {
        return mesh;
    }

    public void render(TextureBuffer buffer) {
        if (mesh.isInvalid()) {
            return;
        }

        instancer.bind(buffer);

        mesh.draw(instancer.instanceCount());
    }

    public void renderOne(TextureBuffer buffer) {
        if (mesh.isInvalid()) {
            return;
        }

        instancer.bind(buffer);

        mesh.draw(1);
    }

    public void delete() {
        if (deleted) {
            return;
        }

        mesh.release();

        deleted = true;
    }
}
