package com.zurrtum.create.client.flywheel.lib.instance;

import com.zurrtum.create.client.flywheel.api.instance.InstanceHandle;
import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.lib.transform.Transform;
import org.joml.*;

import java.lang.Math;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class PosedInstance extends ColoredLitOverlayInstance implements Transform<PosedInstance> {
    public final Matrix4f pose = new Matrix4f();
    public final Matrix3f normal = new Matrix3f();

    public PosedInstance(InstanceType<? extends PosedInstance> type, InstanceHandle handle) {
        super(type, handle);
    }

    @Override
    public PosedInstance mulPose(Matrix4fc pose) {
        this.pose.mul(pose);
        return this;
    }

    @Override
    public PosedInstance mulNormal(Matrix3fc normal) {
        this.normal.mul(normal);
        return this;
    }

    @Override
    public PosedInstance rotateAround(Quaternionfc quaternion, float x, float y, float z) {
        pose.rotateAround(quaternion, x, y, z);
        normal.rotate(quaternion);
        return this;
    }

    @Override
    public PosedInstance translate(float x, float y, float z) {
        pose.translate(x, y, z);
        return this;
    }

    @Override
    public PosedInstance rotate(Quaternionfc quaternion) {
        pose.rotate(quaternion);
        normal.rotate(quaternion);
        return this;
    }

    @Override
    public PosedInstance scale(float x, float y, float z) {
        pose.scale(x, y, z);

        if (x == y && y == z) {
            if (x < 0.0f) {
                normal.scale(-1.0f);
            }

            return this;
        }

        float invX = 1.0f / x;
        float invY = 1.0f / y;
        float invZ = 1.0f / z;
        float f = class_3532.method_23278(Math.abs(invX * invY * invZ));
        normal.scale(f * invX, f * invY, f * invZ);
        return this;
    }

    public PosedInstance setTransform(Matrix4fc pose, Matrix3fc normal) {
        this.pose.set(pose);
        this.normal.set(normal);
        return this;
    }

    public PosedInstance setTransform(class_4587.class_4665 pose) {
        this.pose.set(pose.method_23761());
        normal.set(pose.method_23762());
        return this;
    }

    public PosedInstance setTransform(class_4587 stack) {
        return setTransform(stack.method_23760());
    }

    public PosedInstance setIdentityTransform() {
        pose.identity();
        normal.identity();
        return this;
    }

    /**
     * Sets the transform matrices to be all zeros.
     *
     * <p>
     * This will allow the GPU to quickly discard all geometry for this instance, effectively "turning it off".
     * </p>
     */
    public PosedInstance setZeroTransform() {
        pose.zero();
        normal.zero();
        return this;
    }
}
