package com.zurrtum.create.client.flywheel.lib.model.part;

import com.zurrtum.create.client.flywheel.api.model.Mesh;
import com.zurrtum.create.client.flywheel.lib.internal.FlwLibLink;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import com.zurrtum.create.client.flywheel.lib.model.SimpleQuadMesh;
import com.zurrtum.create.client.flywheel.lib.util.RendererReloadCache;
import com.zurrtum.create.client.flywheel.lib.vertex.PosTexNormalVertexView;
import com.zurrtum.create.client.flywheel.lib.vertex.VertexView;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.NoSuchElementException;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_630;
import net.minecraft.class_765;

public final class MeshTree {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private static final class_4587.class_4665 IDENTITY_POSE = new class_4587().method_23760();
    private static final RendererReloadCache<class_5601, MeshTree> CACHE = new RendererReloadCache<>(MeshTree::convert);

    @Nullable
    private final Mesh mesh;
    private final class_5603 initialPose;
    private final MeshTree[] children;
    private final String[] childNames;

    private MeshTree(@Nullable Mesh mesh, class_5603 initialPose, MeshTree[] children, String[] childNames) {
        this.mesh = mesh;
        this.initialPose = initialPose;
        this.children = children;
        this.childNames = childNames;
    }

    public static MeshTree of(class_5601 layer) {
        return CACHE.get(layer);
    }

    private static MeshTree convert(class_5601 layer) {
        class_5599 entityModels = class_310.method_1551().method_31974();
        class_630 modelPart = entityModels.method_32072(layer);

        return convert(modelPart, THREAD_LOCAL_OBJECTS.get());
    }

    private static MeshTree convert(class_630 modelPart, ThreadLocalObjects objects) {
        var modelPartChildren = FlwLibLink.INSTANCE.getModelPartChildren(modelPart);

        String[] childNames = modelPartChildren.keySet().toArray(String[]::new);
        Arrays.sort(childNames);

        MeshTree[] children = new MeshTree[childNames.length];
        for (int i = 0; i < childNames.length; i++) {
            children[i] = convert(modelPartChildren.get(childNames[i]), objects);
        }

        return new MeshTree(compile(modelPart, objects), modelPart.method_41921(), children, childNames);
    }

    @Nullable
    private static Mesh compile(class_630 modelPart, ThreadLocalObjects objects) {
        if (modelPart.method_32087()) {
            return null;
        }

        VertexWriter vertexWriter = objects.vertexWriter;
        FlwLibLink.INSTANCE.compileModelPart(
            modelPart,
            IDENTITY_POSE,
            vertexWriter,
            class_765.field_32767,
            class_4608.field_21444,
            0xFFFFFFFF
        );
        MemoryBlock data = vertexWriter.copyDataAndReset();

        VertexView vertexView = new PosTexNormalVertexView();
        vertexView.load(data);
        return new SimpleQuadMesh(vertexView, "source=MeshTree");
    }

    @Nullable
    public Mesh mesh() {
        return mesh;
    }

    public class_5603 initialPose() {
        return initialPose;
    }

    public int childCount() {
        return children.length;
    }

    public MeshTree child(int index) {
        return children[index];
    }

    public String childName(int index) {
        return childNames[index];
    }

    public int childIndex(String name) {
        return Arrays.binarySearch(childNames, name);
    }

    public boolean hasChild(String name) {
        return childIndex(name) >= 0;
    }

    @Nullable
    public MeshTree child(String name) {
        int index = childIndex(name);

        if (index < 0) {
            return null;
        }

        return child(index);
    }

    public MeshTree childOrThrow(String name) {
        MeshTree child = child(name);

        if (child == null) {
            throw new NoSuchElementException("Can't find part " + name);
        }

        return child;
    }

    private static class ThreadLocalObjects {
        public final VertexWriter vertexWriter = new VertexWriter();
    }
}