package com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox.ItemValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxRenderer;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform.Sided;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_638;

public class FilteringRenderer {

    public static void tick(class_310 mc) {
        class_239 target = mc.field_1765;
        if (!(target instanceof class_3965 result))
            return;

        class_638 world = mc.field_1687;
        class_2338 pos = result.method_17777();
        class_2680 state = world.method_8320(pos);

        if (mc.field_1724.method_5715())
            return;
        if (!(world.method_8321(pos) instanceof SmartBlockEntity sbe))
            return;

        class_1799 mainhandItem = mc.field_1724.method_5998(class_1268.field_5808);

        List<FilteringBehaviour<?>> behaviours;
        if (sbe instanceof FactoryPanelBlockEntity fpbe) {
            behaviours = FactoryPanelBehaviour.allBehaviours(fpbe);
        } else {
            FilteringBehaviour<?> behaviour = sbe.getBehaviour(FilteringBehaviour.TYPE);
            if (behaviour instanceof SidedFilteringBehaviour sidedBehaviour) {
                behaviour = sidedBehaviour.get(result.method_17780());
            }
            if (behaviour == null) {
                return;
            }
            behaviours = List.of(behaviour);
        }

        for (FilteringBehaviour<?> behaviour : behaviours) {
            if (!behaviour.isActive())
                continue;
            if (behaviour.slotPositioning instanceof ValueBoxTransform.Sided)
                ((Sided) behaviour.slotPositioning).fromSide(result.method_17780());
            if (!behaviour.slotPositioning.shouldRender(world, pos, state))
                continue;
            if (!behaviour.mayInteract(mc.field_1724))
                continue;

            class_1799 filter = behaviour.getFilter();
            boolean isFilterSlotted = filter.method_7909() instanceof FilterItem;
            boolean showCount = behaviour.isCountVisible();
            class_2561 label = behaviour.getLabel();
            boolean hit = behaviour.slotPositioning.testHit(world, pos, state, target.method_17784().method_1020(class_243.method_24954(pos)));

            class_238 emptyBB = new class_238(class_243.field_1353, class_243.field_1353);
            class_238 bb = isFilterSlotted ? emptyBB.method_1009(.45f, .31f, .2f) : emptyBB.method_1014(.25f);

            ValueBox box = new ItemValueBox(label, bb, pos, filter, behaviour.getCountLabelForValueBox());
            box.passive(!hit || behaviour.bypassesInput(mainhandItem));

            Outliner.getInstance().showOutline(Pair.of("filter" + behaviour.netId(), pos), box.transform(behaviour.slotPositioning))
                .lineWidth(1 / 64f).withFaceTexture(hit ? AllSpecialTextures.THIN_CHECKERED : null).highlightFace(result.method_17780());

            if (!hit)
                continue;

            List<class_5250> tip = new ArrayList<>();
            tip.add(label.method_27661());
            tip.add(behaviour.getTip());
            if (showCount)
                tip.add(behaviour.getAmountTip());

            Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
        }
    }

    public static void renderOnBlockEntity(
        SmartBlockEntity be,
        float partialTicks,
        class_4587 ms,
        class_4597 buffer,
        int light,
        int overlay
    ) {

        if (be == null || be.method_11015())
            return;

        class_1937 level = be.method_10997();
        class_2338 blockPos = be.method_11016();

        List<FilteringBehaviour<?>> behaviours;
        if (be instanceof FactoryPanelBlockEntity fpbe) {
            behaviours = FactoryPanelBehaviour.allBehaviours(fpbe);
        } else {
            FilteringBehaviour<?> behaviour = be.getBehaviour(FilteringBehaviour.TYPE);
            if (behaviour == null) {
                return;
            }
            behaviours = List.of(behaviour);
        }

        for (FilteringBehaviour<?> behaviour : behaviours) {
            if (!be.isVirtual()) {
                class_1297 cameraEntity = class_310.method_1551().field_1719;
                if (cameraEntity != null && level == cameraEntity.method_37908()) {
                    float max = behaviour.getRenderDistance();
                    if (cameraEntity.method_19538().method_1025(VecHelper.getCenterOf(blockPos)) > (max * max)) {
                        continue;
                    }
                }
            }

            if (behaviour.behaviour == null || !behaviour.isActive())
                continue;
            if (behaviour.getFilter().method_7960() && !(behaviour instanceof SidedFilteringBehaviour))
                continue;

            ValueBoxTransform slotPositioning = behaviour.slotPositioning;
            class_2680 blockState = be.method_11010();

            if (slotPositioning instanceof Sided sided) {
                class_2350 side = sided.getSide();
                for (class_2350 d : Iterate.directions) {
                    class_1799 filter = behaviour.getFilter(d);
                    if (filter.method_7960())
                        continue;

                    sided.fromSide(d);
                    if (!slotPositioning.shouldRender(level, blockPos, blockState))
                        continue;

                    ms.method_22903();
                    slotPositioning.transform(level, blockPos, blockState, ms);
                    if (blockState.method_27852(AllBlocks.CONTRAPTION_CONTROLS))
                        ValueBoxRenderer.renderFlatItemIntoValueBox(filter, ms, buffer, light, overlay);
                    else
                        ValueBoxRenderer.renderItemIntoValueBox(filter, ms, buffer, light, overlay);
                    ms.method_22909();
                }
                sided.fromSide(side);
            } else if (slotPositioning.shouldRender(level, blockPos, blockState)) {
                ms.method_22903();
                slotPositioning.transform(level, blockPos, blockState, ms);
                ValueBoxRenderer.renderItemIntoValueBox(behaviour.getFilter(), ms, buffer, light, overlay);
                ms.method_22909();
            }
        }
    }

}
