package com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.content.kinetics.motor.MotorValueBox;
import com.zurrtum.create.client.content.kinetics.speedController.ControllerValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsBoard;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsFormatter;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.motor.CreativeMotorBlockEntity;
import com.zurrtum.create.content.kinetics.speedController.SpeedControllerBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_5250;

public class KineticScrollValueBehaviour extends ScrollValueBehaviour<SmartBlockEntity, ServerScrollValueBehaviour> {
    public KineticScrollValueBehaviour(class_2561 label, SmartBlockEntity be, ValueBoxTransform slot) {
        super(label, be, slot);
        withFormatter(v -> String.valueOf(Math.abs(v)));
    }

    public static KineticScrollValueBehaviour motor(CreativeMotorBlockEntity blockEntity) {
        return new KineticScrollValueBehaviour(
            CreateLang.translateDirect("kinetics.creative_motor.rotation_speed"),
            blockEntity,
            new MotorValueBox()
        );
    }

    public static KineticScrollValueBehaviour controller(SpeedControllerBlockEntity blockEntity) {
        return new KineticScrollValueBehaviour(
            CreateLang.translateDirect("kinetics.speed_controller.rotation_speed"),
            blockEntity,
            new ControllerValueBoxTransform()
        );
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        ImmutableList<class_2561> rows = ImmutableList.of(
            class_2561.method_43470("\u27f3").method_27692(class_124.field_1067),
            class_2561.method_43470("\u27f2").method_27692(class_124.field_1067)
        );
        ValueSettingsFormatter formatter = new ValueSettingsFormatter(this::formatSettings);
        return new ValueSettingsBoard(label, 256, 32, rows, formatter);
    }

    public class_5250 formatSettings(ValueSettings settings) {
        return CreateLang.number(Math.max(1, Math.abs(settings.value())))
            .add(CreateLang.text(settings.row() == 0 ? "\u27f3" : "\u27f2").style(class_124.field_1067)).component();
    }
}
