package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.api.goggles.IHaveGoggleInformation;
import com.zurrtum.create.client.api.goggles.IHaveHoveringInformation;
import com.zurrtum.create.client.catnip.lang.FontHelper.Palette;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.content.kinetics.base.IRotate.StressImpact;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

import static net.minecraft.class_124.*;

public class KineticTooltipBehaviour<T extends KineticBlockEntity> extends TooltipBehaviour<T> implements IHaveGoggleInformation, IHaveHoveringInformation {
    public KineticTooltipBehaviour(T be) {
        super(be);
    }

    @Override
    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        boolean notFastEnough = !blockEntity.isSpeedRequirementFulfilled() && blockEntity.getSpeed() != 0;

        if (blockEntity.isOverStressed() && AllConfigs.client().enableOverstressedTooltip.get()) {
            CreateLang.translate("gui.stressometer.overstressed").style(field_1065).forGoggles(tooltip);
            class_2561 hint = CreateLang.translateDirect("gui.contraptions.network_overstressed");
            List<class_2561> cutString = TooltipHelper.cutTextComponent(hint, Palette.GRAY_AND_WHITE);
            for (class_2561 component : cutString)
                CreateLang.builder().add(component.method_27661()).forGoggles(tooltip);
            return true;
        }

        if (notFastEnough) {
            CreateLang.translate("tooltip.speedRequirement").style(field_1065).forGoggles(tooltip);
            class_5250 hint = CreateLang.translateDirect(
                "gui.contraptions.not_fast_enough",
                class_1074.method_4662(blockEntity.method_11010().method_26204().method_63499())
            );
            List<class_2561> cutString = TooltipHelper.cutTextComponent(hint, Palette.GRAY_AND_WHITE);
            for (class_2561 component : cutString)
                CreateLang.builder().add(component.method_27661()).forGoggles(tooltip);
            return true;
        }

        return false;
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (!StressImpact.isEnabled())
            return false;
        float stressAtBase = blockEntity.calculateStressApplied();
        if (class_3532.method_15347(stressAtBase, 0))
            return false;

        CreateLang.translate("gui.goggles.kinetic_stats").forGoggles(tooltip);

        addStressImpactStats(tooltip, stressAtBase);

        return true;
    }

    protected void addStressImpactStats(List<class_2561> tooltip, float stressAtBase) {
        CreateLang.translate("tooltip.stressImpact").style(field_1080).forGoggles(tooltip);

        float stressTotal = stressAtBase * Math.abs(blockEntity.getTheoreticalSpeed());

        CreateLang.number(stressTotal).translate("generic.unit.stress").style(field_1075).space()
            .add(CreateLang.translate("gui.goggles.at_current_speed").style(field_1063)).forGoggles(tooltip, 1);
    }
}
