package com.zurrtum.create.client.foundation.blockEntity.renderer;

import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import net.minecraft.class_1921;
import net.minecraft.class_2586;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public abstract class ColoredOverlayBlockEntityRenderer<T extends class_2586> extends SafeBlockEntityRenderer<T> {

    public ColoredOverlayBlockEntityRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(T be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {

        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        SuperByteBuffer render = render(getOverlayBuffer(be), getColor(be, partialTicks), light);
        render.renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
    }

    protected abstract int getColor(T be, float partialTicks);

    protected abstract SuperByteBuffer getOverlayBuffer(T be);

    public static SuperByteBuffer render(SuperByteBuffer buffer, int color, int light) {
        return buffer.color(color).light(light);
    }

}
