package com.zurrtum.create.client.foundation.render;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

import java.util.BitSet;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class BlockEntityRenderHelper {
    /**
     * Renders the given list of BlockEntities, skipping those not marked in shouldRenderBEs,
     * and marking those that error in erroredBEsOut.
     *
     * @param blockEntities   The list of BlockEntities to render.
     * @param shouldRenderBEs A BitSet marking which BlockEntities in the list should be rendered. This will not be modified.
     * @param erroredBEsOut   A BitSet to mark BlockEntities that error during rendering. This will be modified.
     */
    public static void renderBlockEntities(
        List<class_2586> blockEntities,
        BitSet shouldRenderBEs,
        BitSet erroredBEsOut,
        @Nullable VirtualRenderWorld renderLevel,
        class_1937 realLevel,
        class_4587 ms,
        @Nullable Matrix4f lightTransform,
        class_4597 buffer,
        float pt
    ) {
        class_310 mc = class_310.method_1551();
        class_824 dispatcher = mc.method_31975();
        class_243 camera = mc.field_1773.method_19418().method_19326();
        for (int i = shouldRenderBEs.nextSetBit(0); i >= 0 && i < blockEntities.size(); i = shouldRenderBEs.nextSetBit(i + 1)) {
            class_2586 blockEntity = blockEntities.get(i);
            if (VisualizationManager.supportsVisualization(realLevel) && VisualizationHelper.skipVanillaRender(blockEntity))
                continue;

            class_827<class_2586> renderer = dispatcher.method_3550(blockEntity);
            if (renderer == null) {
                // Don't bother looping over it again if we can't do anything with it.
                erroredBEsOut.set(i);
                continue;
            }

            class_2338 pos = blockEntity.method_11016();
            ms.method_22903();
            TransformStack.of(ms).translate(pos);

            try {
                int realLevelLight = class_761.method_23794(realLevel, getLightPos(lightTransform, pos));

                int light;
                if (renderLevel != null) {
                    renderLevel.setExternalLight(realLevelLight);
                    light = class_761.method_23794(renderLevel, pos);
                } else {
                    light = realLevelLight;
                }

                renderer.method_3569(blockEntity, pt, ms, buffer, light, class_4608.field_21444, camera);

            } catch (Exception e) {
                // Prevent this BE from causing more issues in the future.
                erroredBEsOut.set(i);

                String message = "BlockEntity " + RegisteredObjectsHelper.getKeyOrThrow(blockEntity.method_11017()) + " could not be rendered virtually.";
                if (AllConfigs.client().explainRenderErrors.get())
                    Create.LOGGER.error(message, e);
                else
                    Create.LOGGER.error(message);
            }

            ms.method_22909();
        }

        if (renderLevel != null) {
            renderLevel.resetExternalLight();
        }
    }

    private static class_2338 getLightPos(@Nullable Matrix4f lightTransform, class_2338 contraptionPos) {
        if (lightTransform != null) {
            Vector4f lightVec = new Vector4f(contraptionPos.method_10263() + .5f, contraptionPos.method_10264() + .5f, contraptionPos.method_10260() + .5f, 1);
            lightVec.mul(lightTransform);
            return class_2338.method_49637(lightVec.x(), lightVec.y(), lightVec.z());
        } else {
            return contraptionPos;
        }
    }

}
