package com.zurrtum.create.client.foundation.virtualWorld;

import com.zurrtum.create.client.flywheel.api.visualization.VisualizationLevel;
import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import net.minecraft.class_10286;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1508;
import net.minecraft.class_1657;
import net.minecraft.class_1845;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4076;
import net.minecraft.class_4543;
import net.minecraft.class_5269;
import net.minecraft.class_5362;
import net.minecraft.class_5577;
import net.minecraft.class_5712;
import net.minecraft.class_5712.class_7397;
import net.minecraft.class_6756;
import net.minecraft.class_6880;
import net.minecraft.class_765;
import net.minecraft.class_7699;
import net.minecraft.class_8921;
import net.minecraft.class_9209;
import net.minecraft.class_9895;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class VirtualRenderWorld extends class_1937 implements VisualizationLevel {
    protected final class_1937 level;
    protected final int minBuildHeight;
    protected final int height;
    protected final class_2382 biomeOffset;

    protected final VirtualChunkSource chunkSource;
    protected final class_3568 lightEngine;

    protected final Map<class_2338, class_2680> blockStates = new HashMap<>();
    protected final Map<class_2338, class_2586> blockEntities = new HashMap<>();
    protected final Object2ShortMap<class_4076> nonEmptyBlockCounts = new Object2ShortOpenHashMap<>();

    protected final class_5577<class_1297> entityGetter = new VirtualLevelEntityGetter<>();

    protected final class_2338.class_2339 scratchPos = new class_2338.class_2339();

    protected final Runnable onBlockUpdated;

    private int externalPackedLight = 0;

    public VirtualRenderWorld(class_1937 level, int minBuildHeight, int height, class_2382 biomeOffset, Runnable onBlockUpdated) {
        super(
            (class_5269) level.method_8401(),
            level.method_27983(),
            level.method_30349(),
            level.method_40134(),
            true,
            false,
            0,
            0
        );
        this.level = level;
        this.minBuildHeight = nextMultipleOf16(minBuildHeight);
        this.height = nextMultipleOf16(height);
        this.biomeOffset = biomeOffset;

        this.chunkSource = new VirtualChunkSource(this);
        this.lightEngine = new class_3568(chunkSource, true, false);
        this.onBlockUpdated = onBlockUpdated;
    }

    /**
     * We need to ensure that height and minBuildHeight are multiples of 16.
     * Adapted from: https://math.stackexchange.com/questions/291468
     */
    public static int nextMultipleOf16(int a) {
        if (a < 0) {
            return -(((Math.abs(a) - 1) | 15) + 1);
        } else {
            return ((a - 1) | 15) + 1;
        }
    }

    /**
     * Set an external light value that will be maxed with any light queries.
     */
    public void setExternalLight(int packedLight) {
        this.externalPackedLight = packedLight;
    }

    /**
     * Reset the external light.
     */
    public void resetExternalLight() {
        this.externalPackedLight = 0;
    }

    @Override
    public void method_8413(class_2338 pos, class_2680 oldState, class_2680 newState, int flags) {
        onBlockUpdated.run();
    }

    @Override
    public int method_8314(class_1944 lightType, class_2338 blockPos) {
        var selfBrightness = super.method_8314(lightType, blockPos);

        if (lightType == class_1944.field_9284) {
            return Math.max(selfBrightness, class_765.method_24187(externalPackedLight));
        } else {
            return Math.max(selfBrightness, class_765.method_24186(externalPackedLight));
        }
    }

    public void clear() {
        blockStates.clear();
        blockEntities.clear();

        nonEmptyBlockCounts.forEach((sectionPos, nonEmptyBlockCount) -> {
            if (nonEmptyBlockCount > 0) {
                lightEngine.method_15551(sectionPos, true);
            }
        });

        nonEmptyBlockCounts.clear();
    }

    public void setBlockEntities(Collection<class_2586> blockEntities) {
        this.blockEntities.clear();
        blockEntities.forEach(this::method_8438);
    }

    /**
     * Run this after you're done using setBlock().
     */
    public void runLightEngine() {
        Set<class_1923> chunkPosSet = new ObjectOpenHashSet<>();
        nonEmptyBlockCounts.object2ShortEntrySet().forEach(entry -> {
            if (entry.getShortValue() > 0) {
                chunkPosSet.add(entry.getKey().method_18692());
            }
        });
        for (class_1923 chunkPos : chunkPosSet) {
            lightEngine.method_51471(chunkPos);
        }

        lightEngine.method_15516();
    }

    // MEANINGFUL OVERRIDES

    @Override
    public class_2818 method_8392(int x, int z) {
        throw new UnsupportedOperationException();
    }

    public class_2791 actuallyGetChunk(int x, int z) {
        return method_22342(x, z, class_2806.field_12803);
    }

    @Override
    public class_2791 method_22350(class_2338 pos) {
        return actuallyGetChunk(class_4076.method_18675(pos.method_10263()), class_4076.method_18675(pos.method_10260()));
    }

    @Override
    public boolean method_30092(class_2338 pos, class_2680 newState, int flags, int recursionLeft) {
        if (method_31606(pos)) {
            return false;
        }

        pos = pos.method_10062();

        class_2680 oldState = method_8320(pos);
        if (oldState == newState) {
            return false;
        }

        blockStates.put(pos, newState);

        class_4076 sectionPos = class_4076.method_18682(pos);
        short nonEmptyBlockCount = nonEmptyBlockCounts.getShort(sectionPos);
        boolean prevEmpty = nonEmptyBlockCount == 0;
        if (!oldState.method_26215()) {
            --nonEmptyBlockCount;
        }
        if (!newState.method_26215()) {
            ++nonEmptyBlockCount;
        }
        nonEmptyBlockCounts.put(sectionPos, nonEmptyBlockCount);
        boolean nowEmpty = nonEmptyBlockCount == 0;

        if (prevEmpty != nowEmpty) {
            lightEngine.method_15551(sectionPos, nowEmpty);
        }

        lightEngine.method_15513(pos);

        return true;
    }

    @Override
    public class_3568 method_22336() {
        return lightEngine;
    }

    @Override
    public class_2680 method_8320(class_2338 pos) {
        if (method_31606(pos)) {
            return class_2246.field_10243.method_9564();
        }
        class_2680 state = blockStates.get(pos);
        if (state != null) {
            return state;
        }
        return class_2246.field_10124.method_9564();
    }

    public class_2680 getBlockState(int x, int y, int z) {
        return method_8320(scratchPos.method_10103(x, y, z));
    }

    @Override
    public class_3610 method_8316(class_2338 pos) {
        if (method_31606(pos)) {
            return class_3612.field_15906.method_15785();
        }
        return method_8320(pos).method_26227();
    }

    @Override
    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        if (!method_31606(pos)) {
            return blockEntities.get(pos);
        }
        return null;
    }

    @Override
    public void method_8438(class_2586 blockEntity) {
        class_2338 pos = blockEntity.method_11016();
        if (!method_31606(pos)) {
            blockEntities.put(pos, blockEntity);
        }
    }

    @Override
    public void method_8544(class_2338 pos) {
        if (!method_31606(pos)) {
            blockEntities.remove(pos);
        }
    }

    @Override
    public class_5577<class_1297> method_31592() {
        return entityGetter;
    }

    @Override
    public class_2802 method_8398() {
        return chunkSource;
    }

    @Override
    public int method_31607() {
        return minBuildHeight;
    }

    @Override
    public int method_31605() {
        return height;
    }

    // BIOME OFFSET

    @Override
    public class_6880<class_1959> method_23753(class_2338 pos) {
        return super.method_23753(pos.method_10081(biomeOffset));
    }

    @Override
    public class_6880<class_1959> method_16359(int x, int y, int z) {
        // Control flow should never reach this method,
        // so we add biomeOffset in case some other mod calls this directly.
        return level.method_16359(x + biomeOffset.method_10263(), y + biomeOffset.method_10264(), z + biomeOffset.method_10260());
    }

    @Override
    public class_6880<class_1959> method_22387(int x, int y, int z) {
        // Control flow should never reach this method,
        // so we add biomeOffset in case some other mod calls this directly.
        return level.method_22387(x + biomeOffset.method_10263(), y + biomeOffset.method_10264(), z + biomeOffset.method_10260());
    }

    @Override
    public int method_8615() {
        return level.method_8615();
    }

    // RENDERING CONSTANTS

    @Override
    public int method_22339(class_2338 pos) {
        return 15;
    }

    @Override
    public float method_24852(class_2350 direction, boolean shade) {
        return 1f;
    }

    // THIN WRAPPERS

    @Override
    public class_269 method_8428() {
        return level.method_8428();
    }

    @Override
    public class_10286 method_8433() {
        return level.method_8433();
    }

    @Override
    public class_4543 method_22385() {
        return level.method_22385();
    }

    @Override
    public class_6756<class_2248> method_8397() {
        return level.method_8397();
    }

    @Override
    public class_6756<class_3611> method_8405() {
        return level.method_8405();
    }

    @Override
    public class_7699 method_45162() {
        return level.method_45162();
    }

    @Override
    public class_1845 method_59547() {
        return level.method_59547();
    }

    @Override
    public class_9895 method_61269() {
        return level.method_61269();
    }

    // ADDITIONAL OVERRRIDES

    @Override
    public void method_8455(class_2338 pos, class_2248 block) {
    }

    @Override
    public boolean method_8477(class_2338 pos) {
        return true;
    }

    // UNIMPORTANT IMPLEMENTATIONS

    @Override
    public void method_8465(
        class_1297 player,
        double x,
        double y,
        double z,
        class_6880<class_3414> soundEvent,
        class_3419 soundSource,
        float volume,
        float pitch,
        long seed
    ) {
    }

    @Override
    public void method_8449(
        class_1297 player,
        class_1297 entity,
        class_6880<class_3414> soundEvent,
        class_3419 soundSource,
        float volume,
        float pitch,
        long seed
    ) {
    }

    @Override
    public void method_8454(
        @Nullable class_1297 entity,
        @Nullable class_1282 damageSource,
        @Nullable class_5362 behavior,
        double x,
        double y,
        double z,
        float power,
        boolean createFire,
        class_7867 explosionSourceType,
        class_2394 smallParticle,
        class_2394 largeParticle,
        class_6880<class_3414> soundEvent
    ) {
        level.method_8454(
            entity,
            damageSource,
            behavior,
            x,
            y,
            z,
            power,
            createFire,
            explosionSourceType,
            smallParticle,
            largeParticle,
            soundEvent
        );
    }

    @Override
    public String method_31419() {
        return "";
    }

    @Override
    @Nullable
    public class_1297 method_8469(int id) {
        return null;
    }

    @Override
    public Collection<class_1508> method_65097() {
        return level.method_65097();
    }

    @Override
    public class_8921 method_54719() {
        return level.method_54719();
    }

    @Override
    @Nullable
    public class_22 method_17891(class_9209 mapId) {
        return null;
    }

    @Override
    public void method_8517(int breakerId, class_2338 pos, int progress) {
    }

    @Override
    public void method_8444(@Nullable class_1297 player, int type, class_2338 pos, int data) {
    }

    @Override
    public void method_32888(class_6880<class_5712> gameEvent, class_243 pos, class_7397 context) {
    }

    @Override
    public List<? extends class_1657> method_18456() {
        return Collections.emptyList();
    }

    // Override Starlight's ExtendedWorld interface methods:

    public class_2818 getChunkAtImmediately(final int chunkX, final int chunkZ) {
        return chunkSource.method_12126(chunkX, chunkZ, false);
    }

    public class_2791 getAnyChunkImmediately(final int chunkX, final int chunkZ) {
        return chunkSource.method_12246(chunkX, chunkZ);
    }

    // Intentionally copied from LevelHeightAccessor. Lithium overrides these methods so we need to, too.


    @Override
    public int method_31600() {
        return this.method_31607() + this.method_31605() - 1;
    }

    @Override
    public int method_32890() {
        return this.method_31597() - this.method_32891() + 1;
    }

    @Override
    public int method_32891() {
        return class_4076.method_18675(this.method_31607());
    }

    @Override
    public int method_31597() {
        return class_4076.method_18675(this.method_31600());
    }

    @Override
    public boolean method_62871(int y) {
        return y >= this.method_31607() && y <= this.method_31600();
    }

    @Override
    public boolean method_31606(class_2338 pos) {
        return this.method_31601(pos.method_10264());
    }

    @Override
    public boolean method_31601(int y) {
        return y < this.method_31607() || y > this.method_31600();
    }

    @Override
    public int method_31602(int y) {
        return this.method_31603(class_4076.method_18675(y));
    }

    @Override
    public int method_31603(int coord) {
        return coord - this.method_32891();
    }

    @Override
    public int method_31604(int index) {
        return index + this.method_32891();
    }
}
