package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.redstone.link.controller.LinkedControllerClientHandler;
import com.zurrtum.create.client.content.redstone.link.controller.LinkedControllerClientHandler.Mode;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10444.class_10446;
import net.minecraft.class_10515;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.client.render.model.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import static com.zurrtum.create.Create.MOD_ID;

public class LinkedControllerModel implements class_10439, class_10515<LinkedControllerModel.RenderData> {
    public static final class_2960 ID = class_2960.method_60655(MOD_ID, "model/linked_controller");
    public static final class_2960 ITEM_ID = class_2960.method_60655(MOD_ID, "item/linked_controller/item");
    public static final class_2960 POWERED_ID = class_2960.method_60655(MOD_ID, "item/linked_controller/powered");
    public static final class_2960 TORCH_ID = class_2960.method_60655(MOD_ID, "item/linked_controller/torch");
    public static final class_2960 BUTTON_ID = class_2960.method_60655(MOD_ID, "item/linked_controller/button");

    private static final LerpedFloat equipProgress = LerpedFloat.linear().startWithValue(0);
    private static final List<LerpedFloat> buttons = class_156.method_654(
        new ArrayList<>(6), list -> {
            for (int i = 0; i < 6; i++)
                list.add(LerpedFloat.linear().startWithValue(0));
        }
    );

    public static void tick(class_310 mc) {
        if (mc.method_1493())
            return;

        boolean active = LinkedControllerClientHandler.MODE != Mode.IDLE;
        equipProgress.chase(active ? 1 : 0, .2f, Chaser.EXP);
        equipProgress.tickChaser();

        if (!active)
            return;

        for (int i = 0; i < buttons.size(); i++) {
            LerpedFloat lerpedFloat = buttons.get(i);
            lerpedFloat.chase(LinkedControllerClientHandler.currentlyPressed.contains(i) ? 1 : 0, .4f, Chaser.EXP);
            lerpedFloat.tickChaser();
        }
    }

    public static void resetButtons() {
        for (LerpedFloat button : buttons) {
            button.startWithValue(0);
        }
    }

    private final class_1921 itemLayer = class_4722.method_29382();
    private final class_1921 cutoutLayer = class_1921.method_23581();
    private final int[] tints = new int[0];
    private final class_10809 settings;
    private final Supplier<Vector3f[]> vector;
    private final List<class_777> item;
    private final List<class_777> powered;
    private final List<class_777> torch;
    private final List<class_777> button;

    public LinkedControllerModel(
        class_10809 settings,
        List<class_777> item,
        List<class_777> powered,
        List<class_777> torch,
        List<class_777> button
    ) {
        this.settings = settings;
        this.item = item;
        this.vector = Suppliers.memoize(() -> class_10430.method_67990(item));
        this.powered = powered;
        this.torch = torch;
        this.button = button;
    }

    @Override
    public void method_65584(
        class_10444 state,
        class_1799 stack,
        class_10442 resolver,
        class_811 displayContext,
        @Nullable class_638 world,
        @Nullable class_1309 user,
        int seed
    ) {
        state.method_70946(this);
        state.method_70947();
        class_10446 layerRenderState = state.method_65601();
        layerRenderState.method_67995(vector);
        settings.method_68000(layerRenderState, displayContext);

        RenderData data = new RenderData();
        class_310 mc = class_310.method_1551();
        boolean rightHanded = mc.field_1690.method_42552().method_41753() == class_1306.field_6183;
        class_811 mainHand = rightHanded ? class_811.field_4322 : class_811.field_4321;
        class_811 offHand = rightHanded ? class_811.field_4321 : class_811.field_4322;
        boolean noControllerInMain = !mc.field_1724.method_6047().method_31574(AllItems.LINKED_CONTROLLER);
        if (displayContext == mainHand || (displayContext == offHand && noControllerInMain)) {
            data.equip = true;
            data.active = true;
        }
        if (displayContext == class_811.field_4317) {
            if (stack == mc.field_1724.method_6047())
                data.active = true;
            if (stack == mc.field_1724.method_6079() && noControllerInMain)
                data.active = true;
        }
        data.active &= LinkedControllerClientHandler.MODE != Mode.IDLE;
        layerRenderState.method_65617(this, data);
    }

    @Override
    public void render(
        LinkedControllerModel.RenderData data,
        class_811 displayContext,
        class_4587 matrices,
        class_4597 vertexConsumers,
        int light,
        int overlay,
        boolean glint
    ) {
        assert data != null;
        render(displayContext, matrices, vertexConsumers, light, overlay, RenderType.NORMAL, data.equip, data.active, true);
    }

    public void renderInLectern(
        class_811 displayContext,
        class_4587 matrices,
        class_4597 vertexConsumers,
        int light,
        int overlay,
        boolean active,
        boolean renderDepression
    ) {
        render(displayContext, matrices, vertexConsumers, light, overlay, RenderType.LECTERN, false, active, renderDepression);
    }

    private void render(
        class_811 displayContext,
        class_4587 matrices,
        class_4597 vertexConsumers,
        int light,
        int overlay,
        RenderType renderType,
        boolean equip,
        boolean active,
        boolean renderDepression
    ) {
        float pt = -1;
        matrices.method_22903();

        if (equip) {
            pt = AnimationTickHolder.getPartialTicks();
            float progress = equipProgress.getValue(pt);
            int handModifier = displayContext == class_811.field_4321 ? -1 : 1;
            matrices.method_46416(0, progress / 4, progress / 4 * handModifier);
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(progress * -30 * handModifier));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(progress * -30));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
        }

        renderQuads(displayContext, matrices, vertexConsumers, light, overlay, itemLayer, active ? powered : item);

        if (!active) {
            matrices.method_22909();
            return;
        }
        renderQuads(displayContext, matrices, vertexConsumers, light, overlay, cutoutLayer, torch);
        if (renderType == RenderType.NORMAL) {
            if (LinkedControllerClientHandler.MODE == Mode.BIND) {
                int i = class_3532.method_48781((class_3532.method_15374(AnimationTickHolder.getRenderTime() / 4f) + 1) / 2, 5, 15);
                light = i << 20;
            }
        }
        float s = 1 / 16f;
        float b = s * -.75f;
        int index = 0;
        if (pt == -1) {
            pt = AnimationTickHolder.getPartialTicks();
        }
        matrices.method_22903();
        matrices.method_46416(2 * s, 0, 8 * s);
        renderButton(displayContext, matrices, vertexConsumers, light, overlay, button, pt, b, index++, renderDepression);
        matrices.method_46416(4 * s, 0, 0);
        renderButton(displayContext, matrices, vertexConsumers, light, overlay, button, pt, b, index++, renderDepression);
        matrices.method_46416(-2 * s, 0, 2 * s);
        renderButton(displayContext, matrices, vertexConsumers, light, overlay, button, pt, b, index++, renderDepression);
        matrices.method_46416(0, 0, -4 * s);
        renderButton(displayContext, matrices, vertexConsumers, light, overlay, button, pt, b, index++, renderDepression);
        matrices.method_22909();

        matrices.method_46416(3 * s, 0, 3 * s);
        renderButton(displayContext, matrices, vertexConsumers, light, overlay, button, pt, b, index++, renderDepression);
        matrices.method_46416(2 * s, 0, 0);
        renderButton(displayContext, matrices, vertexConsumers, light, overlay, button, pt, b, index, renderDepression);

        matrices.method_22909();
    }

    private void renderButton(
        class_811 displayContext,
        class_4587 matrices,
        class_4597 vertexConsumers,
        int light,
        int overlay,
        List<class_777> button,
        float pt,
        float b,
        int index,
        boolean renderDepression
    ) {
        matrices.method_22903();
        if (renderDepression) {
            float depression = b * buttons.get(index).getValue(pt);
            matrices.method_46416(0, depression, 0);
        }
        renderQuads(displayContext, matrices, vertexConsumers, light, overlay, itemLayer, button);
        matrices.method_22909();
    }

    private void renderQuads(
        class_811 displayContext,
        class_4587 matrices,
        class_4597 vertexConsumers,
        int light,
        int overlay,
        class_1921 layer,
        List<class_777> quads
    ) {
        class_918.method_62476(displayContext, matrices, vertexConsumers, light, overlay, tints, quads, layer, class_10444.class_10445.field_55341);
    }

    public static class RenderData {
        boolean equip;
        boolean active;
    }

    @Override
    public void method_72175(Set<Vector3f> vertices) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RenderData method_65695(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    public static class Unbaked implements class_10439.class_10441 {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        @Override
        public MapCodec<Unbaked> method_65585() {
            return CODEC;
        }

        @Override
        public void method_62326(class_10103 resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(POWERED_ID);
            resolver.markDependency(TORCH_ID);
            resolver.markDependency(BUTTON_ID);
        }

        @Override
        public class_10439 method_65587(class_10440 context) {
            class_7775 baker = context.comp_3390();
            class_10819 model = baker.method_45872(ITEM_ID);
            class_10419 textures = model.method_68045();
            List<class_777> quads = model.method_68034(textures, baker, class_1086.field_5350).method_68048();
            class_10809 settings = class_10809.method_68001(baker, model, textures);
            return new LinkedControllerModel(settings, quads, bakeQuads(baker, POWERED_ID), bakeQuads(baker, TORCH_ID), bakeQuads(baker, BUTTON_ID));
        }

        private static List<class_777> bakeQuads(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            return model.method_68034(model.method_68045(), baker, class_1086.field_5350).method_68048();
        }
    }

    protected enum RenderType {
        NORMAL,
        LECTERN;
    }
}
