package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.content.equipment.potatoCannon.PotatoCannonItem;
import com.zurrtum.create.content.equipment.potatoCannon.PotatoCannonItem.Ammo;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10444.class_10446;
import net.minecraft.class_10515;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9848;
import net.minecraft.client.render.*;
import net.minecraft.client.render.model.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

import static com.zurrtum.create.Create.MOD_ID;

public class PotatoCannonModel implements class_10439, class_10515<PotatoCannonModel.RenderData> {
    public static final class_2960 ID = class_2960.method_60655(MOD_ID, "model/potato_cannon");
    public static final class_2960 ITEM_ID = class_2960.method_60655(MOD_ID, "item/potato_cannon/item");
    public static final class_2960 COG_ID = class_2960.method_60655(MOD_ID, "item/potato_cannon/cog");

    private final class_1921 layer = class_4722.method_29382();
    private final List<class_777> itemQuads;
    private final class_10809 itemSettings;
    private final Supplier<Vector3f[]> itemVector;
    private final List<class_777> cogQuads;
    private final class_10809 cogSettings;
    private final Supplier<Vector3f[]> cogVector;

    public PotatoCannonModel(class_3545<List<class_777>, class_10809> item, class_3545<List<class_777>, class_10809> cog) {
        itemQuads = item.method_15442();
        itemSettings = item.method_15441();
        itemVector = Suppliers.memoize(() -> class_10430.method_67990(itemQuads));
        cogQuads = cog.method_15442();
        cogSettings = cog.method_15441();
        cogVector = Suppliers.memoize(() -> class_10430.method_67990(cogQuads));
    }

    @Override
    public void method_65584(
        class_10444 state,
        class_1799 stack,
        class_10442 resolver,
        class_811 displayContext,
        @Nullable class_638 world,
        @Nullable class_1309 user,
        int seed
    ) {
        state.method_70946(this);
        state.method_70947();
        class_10444.class_10445 glint;
        if (stack.method_7958()) {
            state.method_70946(class_10444.class_10445.field_55342);
            glint = class_10444.class_10445.field_55342;
        } else {
            glint = class_10444.class_10445.field_55341;
        }
        update(state, displayContext, itemQuads, itemSettings, itemVector, glint);

        CogRenderData cog = new CogRenderData();
        cog.state = update(state, displayContext, cogQuads, cogSettings, cogVector, glint);
        cog.state.method_67993(itemSettings.comp_3768().method_3503(displayContext));
        cog.rotation = AnimationTickHolder.getRenderTime() * -2.5f;
        boolean inMainHand = displayContext == class_811.field_4322 || displayContext == class_811.field_4320;
        if (inMainHand || displayContext == class_811.field_4321 || displayContext == class_811.field_4323) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                boolean leftHanded = player.method_6068() == class_1306.field_6182;
                float speed = Create.POTATO_CANNON_RENDER_HANDLER.getAnimation(inMainHand ^ leftHanded, AnimationTickHolder.getPartialTicks());
                cog.rotation += 360 * class_3532.method_15363(speed * 5, 0, 1);
            }
        }
        cog.rotation %= 360;
        cog.state.method_65617(this, cog);

        if (displayContext != class_811.field_4317) {
            return;
        }
        DecoratorRenderData decorator = new DecoratorRenderData();
        state.method_65601().method_65617(this, decorator);
        if (stack.method_7909() instanceof PotatoCannonItem potatoCannonItem) {
            decorator.barVisible = potatoCannonItem.isModelBarVisible(stack);
        } else {
            decorator.barVisible = stack.method_31578();
        }
        state.method_70946(decorator.barVisible);
        if (decorator.barVisible) {
            decorator.barStep = stack.method_31579();
            decorator.barColor = stack.method_31580();
            state.method_70946(decorator.barStep);
            state.method_70946(decorator.barColor);
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        Ammo ammo = PotatoCannonItem.getAmmo(player, stack);
        if (ammo == null) {
            return;
        }
        decorator.item = new class_10444();
        decorator.item.field_55337 = displayContext;
        resolver.method_65596(decorator.item, ammo.stack(), displayContext, world, user, seed);
    }

    private class_10446 update(
        class_10444 state,
        class_811 displayContext,
        List<class_777> quads,
        class_10809 settings,
        Supplier<Vector3f[]> vector,
        class_10444.class_10445 glint
    ) {
        class_10446 layerRenderState = state.method_65601();
        layerRenderState.method_67992(layer);
        layerRenderState.method_67995(vector);
        settings.method_68000(layerRenderState, displayContext);
        layerRenderState.method_67997().addAll(quads);
        layerRenderState.method_65615(glint);
        return layerRenderState;
    }

    @Override
    public void render(
        RenderData data,
        class_811 displayContext,
        class_4587 matrices,
        class_4597 vertexConsumers,
        int light,
        int overlay,
        boolean glint
    ) {
        assert data != null;
        if (data instanceof CogRenderData cog) {
            matrices.method_46416(0.5f, 0.53125f, 0.5f);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(cog.rotation));
            matrices.method_46416(-0.5f, -0.53125f, -0.5f);
            class_10446 state = cog.state;
            class_918.method_62476(
                displayContext,
                matrices,
                vertexConsumers,
                light,
                overlay,
                state.field_55349,
                state.field_56964,
                state.field_55347,
                state.field_55348
            );
        } else if (data instanceof DecoratorRenderData decorator) {
            if (decorator.barVisible) {
                matrices.method_22903();
                matrices.method_46416(0, 1f, 0.5f);
                matrices.method_22905(0.0625f, -0.0625f, 0.0625f);
                class_4587.class_4665 entry = matrices.method_23760();
                class_4588 vertexConsumer = vertexConsumers.getBuffer(PonderRenderTypes.getGui());
                fill(vertexConsumer, entry, 2, 15, 13, 15, 4, 0, 0, 0, 255);
                fill(
                    vertexConsumer,
                    entry,
                    2,
                    2 + decorator.barStep,
                    13,
                    14,
                    4,
                    class_9848.method_61327(decorator.barColor),
                    class_9848.method_61329(decorator.barColor),
                    class_9848.method_61331(decorator.barColor),
                    255
                );
                matrices.method_22909();
            }
            if (decorator.item != null) {
                boolean flat = !decorator.item.method_65608();
                if (flat && vertexConsumers instanceof class_4597.class_4598 immediate) {
                    immediate.method_22993();
                }
                matrices.method_22903();
                matrices.method_46416(0.5f, 0.5f, 0.5f);
                matrices.method_22905(0.5f, 0.5f, 0.5f);
                matrices.method_46416(-0.5f, -0.5f, -0.5f);
                if (flat) {
                    class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60026);
                }
                decorator.item.method_65604(matrices, vertexConsumers, light, overlay);
                matrices.method_22909();
            }
        }
    }

    private void fill(
        class_4588 vertexConsumer,
        class_4587.class_4665 entry,
        int x1,
        int x2,
        int y1,
        int y2,
        float depth,
        int red,
        int green,
        int blue,
        int alpha
    ) {
        vertexConsumer.method_56824(entry, x1, y1, depth).method_1336(red, green, blue, alpha);
        vertexConsumer.method_56824(entry, x1, y2, depth).method_1336(red, green, blue, alpha);
        vertexConsumer.method_56824(entry, x2, y2, depth).method_1336(red, green, blue, alpha);
        vertexConsumer.method_56824(entry, x2, y1, depth).method_1336(red, green, blue, alpha);
    }

    public interface RenderData {
    }

    private static class CogRenderData implements RenderData {
        class_10446 state;
        float rotation;
    }

    private static class DecoratorRenderData implements RenderData {
        class_10444 item;
        boolean barVisible;
        int barStep;
        int barColor;
    }

    @Override
    public void method_72175(Set<Vector3f> vertices) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RenderData method_65695(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    public static class Unbaked implements class_10439.class_10441 {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        @Override
        public MapCodec<Unbaked> method_65585() {
            return CODEC;
        }

        @Override
        public void method_62326(class_10103 resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(COG_ID);
        }

        @Override
        public class_10439 method_65587(class_10440 context) {
            class_7775 baker = context.comp_3390();
            return new PotatoCannonModel(bake(baker, ITEM_ID), bake(baker, COG_ID));
        }

        private static class_3545<List<class_777>, class_10809> bake(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            class_10419 textures = model.method_68045();
            List<class_777> quads = model.method_68034(textures, baker, class_1086.field_5350).method_68048();
            class_10809 settings = class_10809.method_68001(baker, model, textures);
            return new class_3545<>(quads, settings);
        }
    }
}
