package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9326;
import org.joml.Quaternionf;

public class BasinFluidParticle extends FluidParticle {
    class_2338 basinPos;
    class_243 targetPos;
    class_243 centerOfBasin;
    float yOffset;

    public BasinFluidParticle(
        class_638 world,
        class_3611 fluid,
        class_9326 components,
        FluidConfig config,
        double x,
        double y,
        double z,
        double vx,
        double vy,
        double vz
    ) {
        super(world, fluid, components, config, x, y, z, vx, vy, vz);
        field_3844 = 0;
        field_3852 = 0;
        field_3869 = 0;
        field_3850 = 0;
        yOffset = world.field_9229.method_43057() * 1 / 32f;
        y += yOffset;
        field_17867 = 0;
        field_3847 = 60;
        class_243 currentPos = new class_243(x, y, z);
        basinPos = class_2338.method_49638(currentPos);
        centerOfBasin = VecHelper.getCenterOf(basinPos);

        if (vx != 0) {
            field_3847 = 20;
            class_243 centerOf = VecHelper.getCenterOf(basinPos);
            class_243 diff = currentPos.method_1020(centerOf).method_18805(1, 0, 1).method_1029().method_1021(.375);
            targetPos = centerOf.method_1019(diff);
            field_3858 = this.field_3874 = centerOfBasin.field_1352;
            field_3856 = this.field_3871 = centerOfBasin.field_1350;
        }
    }

    @Override
    public void method_3070() {
        super.method_3070();
        field_17867 = targetPos != null ? Math.max(1 / 32f, ((1f * field_3866) / field_3847) / 8) : 1 / 8f * (1 - ((Math.abs(field_3866 - (field_3847 / 2)) / (1f * field_3847))));

        if (field_3866 % 2 == 0) {
            if (!field_3851.method_8320(basinPos).method_27852(AllBlocks.BASIN) && !BasinBlock.isBasin(field_3851, basinPos)) {
                method_3085();
                return;
            }

            class_2586 blockEntity = field_3851.method_8321(basinPos);
            if (blockEntity instanceof BasinBlockEntity) {
                float totalUnits = ((BasinBlockEntity) blockEntity).getTotalFluidUnits(0);
                if (totalUnits < 1)
                    totalUnits = 0;
                float fluidLevel = class_3532.method_15363(totalUnits / 2000, 0, 1);
                field_3854 = 2 / 16f + basinPos.method_10264() + 12 / 16f * fluidLevel + yOffset;
            }

        }

        if (targetPos != null) {
            float progess = (1f * field_3866) / field_3847;
            class_243 currentPos = centerOfBasin.method_1019(targetPos.method_1020(centerOfBasin).method_1021(progess));
            field_3874 = currentPos.field_1352;
            field_3871 = currentPos.field_1350;
        }
    }

    @Override
    public void method_3074(class_4588 vb, class_4184 info, float pt) {
        Quaternionf rotation = info.method_23767();
        Quaternionf prevRotation = new Quaternionf(rotation);
        rotation.set(1, 0, 0, 1);
        rotation.normalize();
        super.method_3074(vb, info, pt);
        rotation.set(0, 0, 0, 1);
        rotation.mul(prevRotation);
    }

    @Override
    protected boolean canEvaporate() {
        return false;
    }

    public static class Factory implements class_707<FluidParticleData> {
        @Override
        public class_703 createParticle(FluidParticleData data, class_638 world, double x, double y, double z, double vx, double vy, double vz) {
            FluidConfig config = AllFluidConfigs.get(data.fluid());
            if (config == null) {
                return null;
            }
            return new BasinFluidParticle(world, data.fluid(), data.components(), config, x, y, z, vx, vy, vz);
        }
    }
}
