package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.AllFluids;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import net.minecraft.class_2398;
import net.minecraft.class_3611;
import net.minecraft.class_3999;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9326;
import net.minecraft.class_9381;
import org.jetbrains.annotations.NotNull;

public class FluidParticle extends class_4003 {
    private final float uo;
    private final float vo;
    private final class_3611 fluid;
    private final class_9326 components;
    private final FluidConfig config;

    public FluidParticle(
        class_638 world,
        class_3611 fluid,
        class_9326 components,
        FluidConfig config,
        double x,
        double y,
        double z,
        double vx,
        double vy,
        double vz
    ) {
        super(world, x, y, z, vx, vy, vz);

        this.fluid = fluid;
        this.components = components;
        this.config = config;
        this.method_18141(config.still().get());

        this.field_3844 = 1.0F;
        this.field_3861 = 0.8F;
        this.field_3842 = 0.8F;
        this.field_3859 = 0.8F;
        this.multiplyColor(config.tint().apply(components));

        this.field_3852 = vx;
        this.field_3869 = vy;
        this.field_3850 = vz;

        this.field_17867 /= 2.0F;
        this.uo = this.field_3840.method_43057() * 3.0F;
        this.vo = this.field_3840.method_43057() * 3.0F;
    }

    @Override
    protected int method_3068(float p_189214_1_) {
        int brightnessForRender = super.method_3068(p_189214_1_);
        int skyLight = brightnessForRender >> 20;
        int blockLight = (brightnessForRender >> 4) & 0xf;
        blockLight = Math.max(blockLight, fluid.method_15785().method_15759().method_26213());
        return (skyLight << 20) | (blockLight << 4);
    }

    protected void multiplyColor(int color) {
        this.field_3861 *= (float) (color >> 16 & 255) / 255.0F;
        this.field_3842 *= (float) (color >> 8 & 255) / 255.0F;
        this.field_3859 *= (float) (color & 255) / 255.0F;
    }

    @Override
    protected float method_18133() {
        return this.field_17886.method_4580((this.uo + 1.0F) / 4.0F);
    }

    @Override
    protected float method_18134() {
        return this.field_17886.method_4580(this.uo / 4.0F);
    }

    @Override
    protected float method_18135() {
        return this.field_17886.method_4570(this.vo / 4.0F);
    }

    @Override
    protected float method_18136() {
        return this.field_17886.method_4570((this.vo + 1.0F) / 4.0F);
    }

    @Override
    public void method_3070() {
        super.method_3070();
        if (!canEvaporate())
            return;
        if (field_3845)
            method_3085();
        if (!field_3843)
            return;
        if (!field_3845 && field_3851.field_9229.method_43057() < 1 / 8f)
            return;

        Color color = new Color(config.tint().apply(components));
        field_3851.method_8406(
            class_9381.method_58255(
                class_2398.field_11226,
                color.getRedAsFloat(),
                color.getGreenAsFloat(),
                color.getBlueAsFloat()
            ),
            field_3874,
            field_3854,
            field_3871,
            0,
            0,
            0
        );
    }

    protected boolean canEvaporate() {
        return fluid == AllFluids.POTION;
    }

    @Override
    public @NotNull class_3999 method_18122() {
        return class_3999.field_17827;
    }

    public static class Factory implements class_707<FluidParticleData> {
        @Override
        public class_703 createParticle(FluidParticleData data, class_638 world, double x, double y, double z, double vx, double vy, double vz) {
            FluidConfig config = AllFluidConfigs.get(data.fluid());
            if (config == null) {
                return null;
            }
            return new FluidParticle(world, data.fluid(), data.components(), config, x, y, z, vx, vy, vz);
        }
    }
}
