package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.ParrotElement;
import com.zurrtum.create.client.ponder.api.element.ParrotPose;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonHeadBlock;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2756;
import net.minecraft.class_2764;

public class PistonScenes {

    public static void movement(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_piston", "Moving Structures using Mechanical Pistons");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0).add(util.select().position(0, 1, 2)), class_2350.field_11036);

        Selection kinetics = util.select().fromTo(3, 1, 3, 3, 1, 2);
        class_2338 piston = util.grid().at(3, 1, 2);
        class_2338 leverPos = util.grid().at(3, 2, 4);
        class_2338 shaft = util.grid().at(3, 1, 3);

        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 3, 3, 2, 5), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(piston), class_2350.field_11033);
        ElementLink<WorldSectionElement> contraption = scene.world().showIndependentSection(util.select().position(3, 1, 1), class_2350.field_11033);
        scene.world().moveSection(contraption, util.vector().of(0, 0, 1), 0);
        scene.idle(20);
        scene.world().showSectionAndMerge(util.select().position(piston.method_10095().method_10078()), class_2350.field_11033, contraption);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(piston.method_10095().method_10089(2)), class_2350.field_11033, contraption);
        scene.world().showSectionAndMerge(util.select().position(piston.method_10095().method_10067()), class_2350.field_11033, contraption);
        scene.idle(15);

        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.world().modifyKineticSpeed(kinetics, f -> -f);
        scene.effects().rotationDirectionIndicator(shaft);
        scene.world().moveSection(contraption, util.vector().of(-2, 0, 0), 40);
        scene.overlay().showText(55).pointAt(util.vector().topOf(piston)).placeNearTarget().attachKeyFrame()
            .text("Mechanical Pistons can move blocks in front of them");
        scene.idle(65);

        scene.overlay().showText(45).pointAt(util.vector().blockSurface(shaft, class_2350.field_11035)).placeNearTarget()
            .text("Speed and direction of movement depend on the Rotational Input");
        scene.world().setBlock(util.grid().at(2, 1, 1), class_2246.field_10124.method_9564(), false);
        scene.world().setBlock(util.grid().at(0, 1, 2), class_2246.field_10161.method_9564(), false);
        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.world().modifyKineticSpeed(kinetics, f -> -f);
        scene.effects().rotationDirectionIndicator(shaft);
        scene.world().moveSection(contraption, util.vector().of(2, 0, 0), 40);
        scene.idle(60);

        scene.overlay().showControls(util.vector().blockSurface(piston, class_2350.field_11039), Pointing.DOWN, 30).rightClick()
            .withItem(new class_1799(class_1802.field_8777));
        scene.idle(7);
        scene.world().modifyBlock(piston.method_10095(), s -> s.method_11657(MechanicalPistonHeadBlock.TYPE, class_2764.field_12634), false);
        scene.effects().superGlue(piston, class_2350.field_11039, true);

        scene.idle(33);
        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.world().modifyKineticSpeed(kinetics, f -> -f);
        scene.effects().rotationDirectionIndicator(shaft);
        scene.world().moveSection(contraption, util.vector().of(-2, 0, 0), 40);

        scene.idle(25);
        scene.overlay().showText(60).pointAt(util.vector().topOf(piston)).placeNearTarget().attachKeyFrame()
            .text("Sticky Mechanical Pistons can pull the attached blocks back");
        scene.idle(20);
        scene.world().setBlock(util.grid().at(2, 1, 1), class_2246.field_10161.method_9564(), false);
        scene.world().setBlock(util.grid().at(0, 1, 2), class_2246.field_10124.method_9564(), false);
        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.world().modifyKineticSpeed(kinetics, f -> -f);
        scene.effects().rotationDirectionIndicator(shaft);
        scene.world().moveSection(contraption, util.vector().of(2, 0, 0), 40);

        scene.idle(50);
        scene.world().setBlock(util.grid().at(2, 1, 1), class_2246.field_10124.method_9564(), false);

        scene.world().replaceBlocks(util.select().fromTo(2, 3, 2, 2, 2, 0), class_2246.field_10161.method_9564(), false);
        scene.overlay().showOutline(
            PonderPalette.GREEN,
            "glue",
            util.select().fromTo(2, 2, 3, 2, 1, 3).add(util.select().fromTo(2, 1, 3, 2, 1, 1)).add(util.select().position(1, 1, 1)),
            40
        );
        scene.overlay().showControls(util.vector().centerOf(util.grid().at(2, 2, 0)), Pointing.RIGHT, 40)
            .withItem(AllItems.SUPER_GLUE.method_7854());

        ElementLink<WorldSectionElement> chassis = scene.world().showIndependentSection(util.select().fromTo(2, 2, 0, 2, 3, 2), class_2350.field_11033);
        scene.world().moveSection(chassis, util.vector().of(0, -1, 1), 0);
        scene.addKeyframe();
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(1, 2, 0), class_2350.field_11034, chassis);
        scene.idle(15);
        scene.effects().superGlue(piston.method_10067().method_10095(), class_2350.field_11039, true);
        scene.overlay().showText(80).pointAt(util.vector().topOf(piston.method_10067())).placeNearTarget().sharedText("movement_anchors");

        scene.idle(90);
        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.world().modifyKineticSpeed(kinetics, f -> -f);
        scene.effects().rotationDirectionIndicator(shaft);
        scene.world().moveSection(contraption, util.vector().of(-2, 0, 0), 40);
        scene.world().moveSection(chassis, util.vector().of(-2, 0, 0), 40);
    }

    public static void poles(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("piston_pole", "Piston Extension Poles");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> -f);

        Selection kinetics = util.select().fromTo(3, 1, 3, 3, 1, 2);
        class_2338 piston = util.grid().at(3, 1, 2);

        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 3, 3, 2, 5), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(piston), class_2350.field_11033);
        ElementLink<WorldSectionElement> contraption = scene.world().showIndependentSection(util.select().position(3, 1, 1), class_2350.field_11033);
        scene.world().moveSection(contraption, util.vector().of(0, 0, 1), 0);
        scene.idle(20);

        class_2338 leverPos = util.grid().at(3, 2, 4);
        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.world().setKineticSpeed(kinetics, 16);
        scene.idle(10);

        scene.overlay().showOutlineWithText(util.select().position(piston), 50).colored(PonderPalette.RED).placeNearTarget().attachKeyFrame()
            .text("Without attached Poles, a Mechanical Piston cannot move");
        scene.idle(60);

        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.world().setKineticSpeed(kinetics, 0);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(piston.method_10095().method_10078()), class_2350.field_11033, contraption);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(piston.method_10095().method_10089(2)), class_2350.field_11033, contraption);
        scene.idle(10);

        scene.overlay().showOutline(PonderPalette.RED, new Object(), util.select().fromTo(piston.method_10078(), piston.method_10089(2)), 100);
        scene.overlay().showOutlineWithText(util.select().fromTo(piston.method_10067(), piston.method_10088(2)), 100)
            .text("The Length of pole added at its back determines the Extension Range").attachKeyFrame().placeNearTarget()
            .colored(PonderPalette.GREEN);
        scene.idle(110);

        scene.world().showSectionAndMerge(util.select().position(piston.method_10095().method_10067()), class_2350.field_11034, contraption);
        scene.idle(10);
        ElementLink<ParrotElement> birb = scene.special().createBirb(util.vector().topOf(piston.method_10067()), ParrotPose.FaceCursorPose::new);
        scene.idle(15);

        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.world().setKineticSpeed(kinetics, 16);
        scene.world().moveSection(contraption, util.vector().of(-2, 0, 0), 40);
        scene.special().moveParrot(birb, util.vector().of(-2, 0, 0), 40);

    }

    public static void movementModes(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_piston_modes", "Movement Modes of the Mechanical Piston");
        scene.configureBasePlate(0, 0, 5);
        Selection rose = util.select().fromTo(0, 2, 2, 0, 1, 2);
        scene.world().showSection(util.select().layer(0).add(rose), class_2350.field_11036);

        Selection kinetics = util.select().fromTo(3, 1, 3, 3, 1, 2);
        class_2338 piston = util.grid().at(3, 1, 2);
        class_2338 leverPos = util.grid().at(3, 2, 4);
        class_2338 shaft = util.grid().at(3, 1, 3);

        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 3, 3, 2, 5), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(piston), class_2350.field_11033);
        ElementLink<WorldSectionElement> contraption = scene.world().showIndependentSection(util.select().position(3, 1, 1), class_2350.field_11033);
        scene.world().moveSection(contraption, util.vector().of(0, 0, 1), 0);
        scene.idle(20);
        scene.world().showSectionAndMerge(util.select().position(piston.method_10095().method_10078()), class_2350.field_11033, contraption);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(piston.method_10095().method_10089(2)), class_2350.field_11033, contraption);
        scene.world().showSectionAndMerge(util.select().position(piston.method_10095().method_10067()), class_2350.field_11033, contraption);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(piston.method_10095().method_10067().method_10084()), class_2350.field_11033, contraption);
        scene.idle(15);
        scene.effects().superGlue(piston.method_10067(), class_2350.field_11036, true);
        scene.idle(10);

        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.world().modifyKineticSpeed(kinetics, f -> -f);
        scene.effects().rotationDirectionIndicator(shaft);
        scene.world().moveSection(contraption, util.vector().of(-2, 0, 0), 40);
        scene.idle(40);

        scene.world().destroyBlock(util.grid().at(0, 1, 2));
        scene.world().destroyBlock(util.grid().at(0, 2, 2));
        scene.idle(10);
        scene.overlay().showOutlineWithText(rose, 70).text("Whenever Pistons stop moving, the moved structure reverts to blocks").attachKeyFrame()
            .colored(PonderPalette.RED);
        scene.idle(80);

        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.world().modifyKineticSpeed(kinetics, f -> -f);
        scene.effects().rotationDirectionIndicator(shaft);
        scene.world().moveSection(contraption, util.vector().of(2, 0, 0), 40);
        scene.world().hideSection(rose, class_2350.field_11036);
        scene.idle(50);

        scene.world().setBlock(util.grid().at(0, 1, 2), class_2246.field_10430.method_9564(), false);
        scene.world().setBlock(util.grid().at(0, 2, 2), class_2246.field_10430.method_9564().method_11657(class_2320.field_10929, class_2756.field_12609), false);
        scene.world().showIndependentSection(rose, class_2350.field_11033);
        class_243 filter = util.vector().topOf(piston).method_1031(.125, 0, 0);
        scene.overlay().showFilterSlotInput(filter, class_2350.field_11036, 60);
        scene.overlay().showControls(filter.method_1031(0, .125, 0), Pointing.DOWN, 60).rightClick();
        scene.overlay().showText(70).pointAt(filter.method_1031(-.125, 0, 0)).placeNearTarget().attachKeyFrame().sharedText("behaviour_modify_value_panel");
        scene.idle(80);

        scene.effects().indicateRedstone(leverPos);
        scene.world().toggleRedstonePower(util.select().fromTo(leverPos, leverPos.method_10074()));
        scene.world().modifyKineticSpeed(kinetics, f -> -f);
        scene.effects().rotationDirectionIndicator(shaft);
        scene.world().moveSection(contraption, util.vector().of(-2, 0, 0), 40);
        scene.idle(50);
        scene.overlay().showText(120).colored(PonderPalette.GREEN).pointAt(util.vector().blockSurface(util.grid().at(0, 1, 2), class_2350.field_11039))
            .placeNearTarget().text("It can be configured never to revert to solid blocks, or only at the location it started at");

    }

}