package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerSidedFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class TunnelScenes {

    public static void andesite(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("andesite_tunnel", "Using Andesite Tunnels");
        scene.configureBasePlate(0, 0, 5);

        scene.world().cycleBlockProperty(util.grid().at(2, 1, 2), BeltBlock.CASING);

        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(4, 1, 5, 4, 1, 3), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(4, 1, 2, 0, 1, 2), class_2350.field_11035);
        scene.idle(10);

        List<ElementLink<WorldSectionElement>> tunnels = new ArrayList<>(3);
        for (int i = 0; i < 3; i++) {
            tunnels.add(scene.world().showIndependentSection(util.select().position(1 + i, 2, 4), class_2350.field_11033));
            scene.world().moveSection(tunnels.get(i), util.vector().of(0, 0, -2), 0);
            scene.idle(4);
        }

        for (int i = 0; i < 3; i++) {
            scene.world().cycleBlockProperty(util.grid().at(1 + i, 1, 2), BeltBlock.CASING);
            scene.world().modifyBlockEntityNBT(
                util.select().position(1 + i, 1, 2),
                BeltBlockEntity.class,
                nbt -> nbt.method_67494("Casing", BeltBlockEntity.CasingType.CODEC, BeltBlockEntity.CasingType.ANDESITE),
                true
            );
            scene.idle(4);
        }

        scene.overlay().showText(60).attachKeyFrame().pointAt(util.vector().topOf(util.grid().at(1, 2, 2))).placeNearTarget()
            .text("Andesite Tunnels can be used to cover up your belts");
        scene.idle(70);

        for (int i = 0; i < 3; i++) {
            scene.world().cycleBlockProperty(util.grid().at(1 + i, 1, 2), BeltBlock.CASING);
            scene.world().hideIndependentSection(tunnels.get(i), class_2350.field_11036);
            scene.idle(4);
        }
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(2, 1, 0, 0, 1, 1), class_2350.field_11035);
        scene.idle(10);
        scene.world().showSection(util.select().position(2, 2, 2), class_2350.field_11033);
        scene.idle(10);
        scene.world().cycleBlockProperty(util.grid().at(2, 1, 2), BeltBlock.CASING);

        scene.overlay().showText(60).attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11043)).placeNearTarget()
            .text("Whenever an Andesite Tunnel has connections to the sides...");
        scene.idle(70);

        scene.overlay().showControls(util.vector().topOf(util.grid().at(4, 1, 2)), Pointing.DOWN, 20).withItem(new class_1799(class_1802.field_27022));
        scene.idle(7);
        scene.world().createItemOnBelt(util.grid().at(4, 1, 2), class_2350.field_11036, new class_1799(class_1802.field_27022, 64));
        scene.idle(40);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 1 / 16f);
        scene.overlay().showText(80).attachKeyFrame().text("...they will split exactly one item off of any passing stacks")
            .pointAt(util.vector().blockSurface(util.grid().at(2, 1, 0), class_2350.field_11039)).placeNearTarget();
        scene.idle(90);
        scene.overlay().showText(80).text("The remainder will continue on its path")
            .pointAt(util.vector().blockSurface(util.grid().at(0, 1, 2), class_2350.field_11036)).placeNearTarget();
        scene.idle(90);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 16f);
    }

    public static void brass(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("brass_tunnel", "Using Brass Tunnels");
        scene.configureBasePlate(1, 0, 5);
        scene.world().cycleBlockProperty(util.grid().at(3, 1, 2), BeltBlock.CASING);

        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(5, 1, 5, 5, 1, 3), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(5, 1, 2, 1, 1, 2), class_2350.field_11035);
        scene.idle(10);

        List<ElementLink<WorldSectionElement>> tunnels = new ArrayList<>(3);
        for (int i = 0; i < 3; i++) {
            tunnels.add(scene.world().showIndependentSection(util.select().position(2 + i, 2, 4), class_2350.field_11033));
            scene.world().moveSection(tunnels.get(i), util.vector().of(0, 0, -2), 0);
            scene.idle(4);
        }

        for (int i = 0; i < 3; i++) {
            scene.world().cycleBlockProperty(util.grid().at(2 + i, 1, 2), BeltBlock.CASING);
            scene.world().modifyBlockEntityNBT(
                util.select().position(2 + i, 1, 2),
                BeltBlockEntity.class,
                nbt -> nbt.method_67494("Casing", BeltBlockEntity.CasingType.CODEC, BeltBlockEntity.CasingType.BRASS),
                true
            );
            scene.idle(4);
        }

        scene.overlay().showText(60).attachKeyFrame().pointAt(util.vector().topOf(util.grid().at(2, 2, 2))).placeNearTarget()
            .text("Brass Tunnels can be used to cover up your belts");
        scene.idle(70);

        for (int i = 0; i < 3; i++) {
            scene.world().cycleBlockProperty(util.grid().at(2 + i, 1, 2), BeltBlock.CASING);
            scene.world().hideIndependentSection(tunnels.get(i), class_2350.field_11036);
            scene.idle(4);
        }
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(3, 1, 0, 1, 1, 1), class_2350.field_11035);
        scene.idle(10);
        scene.world().showSection(util.select().position(3, 2, 2), class_2350.field_11033);
        scene.idle(10);
        scene.world().cycleBlockProperty(util.grid().at(3, 1, 2), BeltBlock.CASING);
        scene.idle(10);

        class_2338 tunnelPos = util.grid().at(3, 2, 2);
        for (class_2350 d : Iterate.horizontalDirections) {
            if (d == class_2350.field_11035)
                continue;
            class_243 filter = getTunnelFilterVec(tunnelPos, d);
            scene.overlay().showFilterSlotInput(filter, d, 40);
            scene.idle(3);
        }

        scene.overlay().showText(60).attachKeyFrame().pointAt(getTunnelFilterVec(tunnelPos, class_2350.field_11039)).placeNearTarget()
            .text("Brass Tunnels have filter slots on each open side");
        scene.idle(70);

        scene.rotateCameraY(70);

        scene.idle(20);
        class_243 tunnelFilterVec = getTunnelFilterVec(tunnelPos, class_2350.field_11034);
        scene.overlay().showFilterSlotInput(tunnelFilterVec, class_2350.field_11034, 10);
        scene.overlay().showText(60).attachKeyFrame().pointAt(tunnelFilterVec).placeNearTarget()
            .text("Filters on inbound connections simply block non-matching items");
        class_1799 copper = new class_1799(class_1802.field_27022);
        Class<BrassTunnelBlockEntity> tunnelClass = BrassTunnelBlockEntity.class;
        scene.world()
            .modifyBlockEntity(tunnelPos, tunnelClass, be -> be.getBehaviour(ServerSidedFilteringBehaviour.TYPE).setFilter(class_2350.field_11034, copper));
        scene.overlay().showControls(tunnelFilterVec, Pointing.DOWN, 30).withItem(copper);
        class_1799 zinc = AllItems.ZINC_INGOT.method_7854();
        scene.world().createItemOnBelt(util.grid().at(5, 1, 2), class_2350.field_11034, zinc);
        scene.idle(70);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), -2);
        scene.idle(20);
        scene.rotateCameraY(-70);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), -.5f);
        scene.idle(20);
        scene.world().modifyBlockEntity(
            tunnelPos,
            tunnelClass,
            be -> be.getBehaviour(ServerSidedFilteringBehaviour.TYPE).setFilter(class_2350.field_11034, class_1799.field_8037)
        );

        tunnelFilterVec = getTunnelFilterVec(tunnelPos, class_2350.field_11043);
        scene.overlay().showFilterSlotInput(tunnelFilterVec, class_2350.field_11043, 40);
        tunnelFilterVec = getTunnelFilterVec(tunnelPos, class_2350.field_11039);
        scene.overlay().showFilterSlotInput(tunnelFilterVec, class_2350.field_11039, 40);
        scene.overlay().showText(60).attachKeyFrame().pointAt(tunnelFilterVec).placeNearTarget()
            .text("Filters on outbound connections can be used to sort items by type");
        scene.idle(70);

        scene.overlay().showControls(tunnelFilterVec, Pointing.LEFT, 30).withItem(copper);
        scene.world()
            .modifyBlockEntity(tunnelPos, tunnelClass, be -> be.getBehaviour(ServerSidedFilteringBehaviour.TYPE).setFilter(class_2350.field_11039, copper));
        scene.idle(4);
        tunnelFilterVec = getTunnelFilterVec(tunnelPos, class_2350.field_11043);
        scene.overlay().showControls(tunnelFilterVec, Pointing.RIGHT, 30).withItem(zinc);
        scene.world()
            .modifyBlockEntity(tunnelPos, tunnelClass, be -> be.getBehaviour(ServerSidedFilteringBehaviour.TYPE).setFilter(class_2350.field_11043, zinc));

        scene.world().multiplyKineticSpeed(util.select().everywhere(), 1.5f);
        for (int i = 0; i < 6; i++) {
            scene.world().createItemOnBelt(util.grid().at(5, 1, 2), class_2350.field_11034, i % 2 == 0 ? zinc : copper);
            scene.idle(12);
        }

        scene.idle(30);
        scene.world().modifyBlockEntity(
            tunnelPos,
            tunnelClass,
            be -> be.getBehaviour(ServerSidedFilteringBehaviour.TYPE).setFilter(class_2350.field_11043, class_1799.field_8037)
        );
        scene.world().modifyBlockEntity(
            tunnelPos,
            tunnelClass,
            be -> be.getBehaviour(ServerSidedFilteringBehaviour.TYPE).setFilter(class_2350.field_11039, class_1799.field_8037)
        );
        scene.idle(10);

        class_243 tunnelTop = util.vector().topOf(tunnelPos);
        scene.overlay().showCenteredScrollInput(tunnelPos, class_2350.field_11036, 120);
        scene.overlay().showText(120).attachKeyFrame().pointAt(tunnelTop).placeNearTarget()
            .text("Whenever a passing item has multiple valid exits, the distribution mode will decide how to handle it");
        for (int i = 0; i < 3; i++) {
            scene.idle(40);
            scene.world().createItemOnBelt(util.grid().at(5, 1, 2), class_2350.field_11034, new class_1799(AllItems.BRASS_INGOT, 63));
        }
        scene.idle(30);

        scene.world().hideSection(util.select().position(3, 2, 2), class_2350.field_11036);
        scene.idle(5);
        scene.world().hideSection(util.select().fromTo(5, 1, 2, 1, 1, 0), class_2350.field_11036);
        scene.idle(15);

        ElementLink<WorldSectionElement> newBelt = scene.world()
            .showIndependentSection(util.select().fromTo(3, 3, 2, 0, 3, 4).add(util.select().fromTo(5, 3, 3, 4, 3, 3)), class_2350.field_11033);
        scene.world().moveSection(newBelt, util.vector().of(0, -2, -1), 0);
        scene.idle(15);
        for (int i = 0; i < 3; i++) {
            scene.idle(4);
            scene.world().showSectionAndMerge(util.select().position(3, 4, 2 + i), class_2350.field_11033, newBelt);
        }

        scene.overlay().showOutlineWithText(util.select().fromTo(3, 1, 1, 3, 2, 3), 80).attachKeyFrame().placeNearTarget()
            .text("Brass Tunnels on parallel belts will form a group");
        scene.idle(90);

        class_1799 item1 = new class_1799(class_1802.field_8179);
        class_1799 item2 = new class_1799(class_1802.field_20417);
        class_1799 item3 = new class_1799(class_1802.field_16998);

        tunnelFilterVec = getTunnelFilterVec(tunnelPos, class_2350.field_11039);
        class_2338 newTunnelPos = tunnelPos.method_10086(2).method_10072();
        scene.overlay().showControls(tunnelFilterVec.method_1031(0, 0, -1), Pointing.RIGHT, 20).withItem(item1);
        scene.world().modifyBlockEntity(
            newTunnelPos.method_10095(),
            tunnelClass,
            be -> be.getBehaviour(ServerSidedFilteringBehaviour.TYPE).setFilter(class_2350.field_11039, item1)
        );
        scene.idle(4);
        scene.overlay().showControls(tunnelFilterVec, Pointing.DOWN, 20).withItem(item2);
        scene.world()
            .modifyBlockEntity(newTunnelPos, tunnelClass, be -> be.getBehaviour(ServerSidedFilteringBehaviour.TYPE).setFilter(class_2350.field_11039, item2));
        scene.idle(4);
        scene.overlay().showControls(tunnelFilterVec.method_1031(0, 0, 1), Pointing.LEFT, 20).withItem(item3);
        scene.world().modifyBlockEntity(
            newTunnelPos.method_10072(),
            tunnelClass,
            be -> be.getBehaviour(ServerSidedFilteringBehaviour.TYPE).setFilter(class_2350.field_11039, item3)
        );
        scene.idle(30);

        scene.overlay().showText(80).pointAt(tunnelTop).placeNearTarget().text("Incoming Items will now be distributed across all connected exits");
        scene.idle(90);

        class_2338 beltPos = util.grid().at(5, 3, 3);
        class_243 m = util.vector().of(0, 0.1, 0);
        class_243 spawn = util.vector().centerOf(util.grid().at(5, 3, 2));
        scene.world().createItemEntity(spawn, m, item1);
        scene.idle(12);
        scene.world().createItemOnBelt(beltPos, class_2350.field_11036, item1);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.world().createItemEntity(spawn, m, item2);
        scene.idle(12);
        scene.world().createItemOnBelt(beltPos, class_2350.field_11036, item2);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.world().createItemEntity(spawn, m, item3);
        scene.idle(12);
        scene.world().createItemOnBelt(beltPos, class_2350.field_11036, item3);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.idle(50);

        scene.world().showSectionAndMerge(util.select().position(3, 5, 2), class_2350.field_11033, newBelt);

        scene.overlay().showText(80).pointAt(util.vector().blockSurface(tunnelPos.method_10084().method_10095(), class_2350.field_11039)).placeNearTarget()
            .text("For this, items can also be inserted into the Tunnel block directly");
        scene.idle(20);

        beltPos = util.grid().at(3, 3, 3);
        spawn = util.vector().centerOf(util.grid().at(3, 5, 1));
        scene.world().createItemEntity(spawn, m, item1);
        scene.idle(12);
        scene.world().createItemOnBelt(beltPos, class_2350.field_11034, item1);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.world().createItemEntity(spawn, m, item2);
        scene.idle(12);
        scene.world().createItemOnBelt(beltPos, class_2350.field_11034, item2);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.world().createItemEntity(spawn, m, item3);
        scene.idle(12);
        scene.world().createItemOnBelt(beltPos, class_2350.field_11034, item3);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.idle(30);

    }

    protected static class_243 getTunnelFilterVec(class_2338 pos, class_2350 d) {
        return VecHelper.getCenterOf(pos).method_1019(class_243.method_24954(d.method_62675()).method_1021(.5)).method_1031(0, 0.3, 0);
    }

    public static void brassModes(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("brass_tunnel_modes", "Distribution Modes of the Brass Tunnel");
        scene.configureBasePlate(0, 1, 5);
        class_2680 barrier = class_2246.field_10499.method_9564();
        scene.world().setBlock(util.grid().at(1, 1, 0), barrier, false);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 1, 1, 5, 1, 5).add(util.select().fromTo(3, 2, 5, 1, 2, 5)), class_2350.field_11033);
        scene.idle(10);
        for (int i = 0; i < 3; i++) {
            scene.world().showSection(util.select().position(3 - i, 2, 3), class_2350.field_11033);
            scene.idle(4);
        }

        class_243 tunnelTop = util.vector().topOf(util.grid().at(2, 2, 3));
        scene.overlay().showControls(tunnelTop, Pointing.DOWN, 80).rightClick();
        scene.idle(7);
        scene.overlay().showCenteredScrollInput(util.grid().at(2, 2, 3), class_2350.field_11036, 120);
        scene.overlay().showText(120).attachKeyFrame().pointAt(tunnelTop).placeNearTarget()
            .text("The distribution behaviour of Brass Tunnels can be configured");
        scene.idle(130);

        Class<BrassTunnelBlockEntity> tunnelClass = BrassTunnelBlockEntity.class;
        ElementLink<WorldSectionElement> blockage = scene.world().showIndependentSection(util.select().position(4, 1, 0), class_2350.field_11036);
        scene.world().moveSection(blockage, util.vector().of(-3, 0, 0), 0);

        class_243 modeVec = util.vector().of(4, 2.5, 3);
        scene.overlay().showControls(modeVec, Pointing.RIGHT, 140).showing(AllIcons.I_TUNNEL_SPLIT);

        ElementLink<WorldSectionElement> blockage2 = null;

        for (int i = 0; i < 32; i++) {
            if (i < 30)
                scene.world().createItemOnBelt(util.grid().at(1, 1, 5), class_2350.field_11034, new class_1799(class_1802.field_8543, 12));
            scene.idle(i > 8 ? 30 : 40);

            if (i == 0) {
                scene.overlay().showText(80).attachKeyFrame().pointAt(tunnelTop).placeNearTarget()
                    .text("'Split' will attempt to distribute the stack evenly between available outputs");
            }

            if (i == 2) {
                scene.overlay().showText(60).text("If an output is unable to take more items, it will be skipped")
                    .pointAt(util.vector().blockSurface(util.grid().at(1, 1, 2), class_2350.field_11036)).placeNearTarget().colored(PonderPalette.GREEN);
            }

            if (i == 4) {
                scene.overlay().showControls(modeVec, Pointing.RIGHT, 140).showing(AllIcons.I_TUNNEL_FORCED_SPLIT);
                scene.world().modifyBlockEntity(
                    util.grid().at(1, 2, 3),
                    tunnelClass,
                    be -> be.getBehaviour(ServerScrollOptionBehaviour.TYPE).setValue(BrassTunnelBlockEntity.SelectionMode.FORCED_SPLIT.ordinal())
                );
            }

            if (i == 5) {
                scene.overlay().showText(80).attachKeyFrame().text("'Forced Split' will never skip outputs, and instead wait until they are free")
                    .pointAt(util.vector().blockSurface(util.grid().at(1, 1, 2), class_2350.field_11036)).placeNearTarget().colored(PonderPalette.RED);
                scene.idle(60);
                scene.world().moveSection(blockage, util.vector().of(-1, 0, 0), 10);
                scene.world().setBlock(util.grid().at(1, 1, 0), class_2246.field_10124.method_9564(), false);
                scene.world().multiplyKineticSpeed(util.select().everywhere(), 1.5f);
            }

            if (i == 7) {
                scene.world().modifyBlockEntity(
                    util.grid().at(1, 2, 3),
                    tunnelClass,
                    be -> be.getBehaviour(ServerScrollOptionBehaviour.TYPE).setValue(BrassTunnelBlockEntity.SelectionMode.ROUND_ROBIN.ordinal())
                );
                scene.overlay().showControls(modeVec, Pointing.RIGHT, 140).showing(AllIcons.I_TUNNEL_ROUND_ROBIN);
                scene.overlay().showText(80).attachKeyFrame().pointAt(tunnelTop).placeNearTarget()
                    .text("'Round Robin' keeps stacks whole, and cycles through outputs iteratively");
            }

            if (i == 7) {
                scene.world().moveSection(blockage, util.vector().of(1, 0, 0), 10);
                scene.world().setBlock(util.grid().at(1, 1, 0), barrier, false);
            }

            if (i == 13) {
                scene.overlay().showText(60).text("Once Again, if an output is unable to take more items, it will be skipped").placeNearTarget()
                    .pointAt(util.vector().blockSurface(util.grid().at(1, 1, 2), class_2350.field_11036)).colored(PonderPalette.GREEN);
            }

            if (i == 15) {
                scene.overlay().showControls(modeVec, Pointing.RIGHT, 140).showing(AllIcons.I_TUNNEL_FORCED_ROUND_ROBIN);
                scene.world().modifyBlockEntity(
                    util.grid().at(1, 2, 3),
                    tunnelClass,
                    be -> be.getBehaviour(ServerScrollOptionBehaviour.TYPE)
                        .setValue(BrassTunnelBlockEntity.SelectionMode.FORCED_ROUND_ROBIN.ordinal())
                );
            }

            if (i == 16) {
                scene.overlay().showText(50).attachKeyFrame().placeNearTarget().text("'Forced Round Robin' never skips outputs")
                    .pointAt(util.vector().blockSurface(util.grid().at(1, 1, 2), class_2350.field_11036)).colored(PonderPalette.RED);
                scene.idle(30);
                scene.world().moveSection(blockage, util.vector().of(-1, 0, 0), 10);
                scene.world().setBlock(util.grid().at(1, 1, 0), class_2246.field_10124.method_9564(), false);
            }

            if (i == 19) {
                scene.overlay().showControls(modeVec, Pointing.RIGHT, 140).showing(AllIcons.I_TUNNEL_PREFER_NEAREST);
                scene.world().modifyBlockEntity(
                    util.grid().at(1, 2, 3),
                    tunnelClass,
                    be -> be.getBehaviour(ServerScrollOptionBehaviour.TYPE).setValue(BrassTunnelBlockEntity.SelectionMode.PREFER_NEAREST.ordinal())
                );
                scene.world().moveSection(blockage, util.vector().of(1, 0, 0), 10);
                scene.world().setBlock(util.grid().at(1, 1, 0), barrier, false);
                scene.overlay().showText(70).attachKeyFrame().text("'Prefer Nearest' prioritizes the outputs closest to the items' input location")
                    .pointAt(util.vector().blockSurface(util.grid().at(1, 1, 2), class_2350.field_11036)).placeNearTarget().colored(PonderPalette.GREEN);
            }

            if (i == 21) {
                scene.world().setBlock(util.grid().at(2, 1, 0), class_2246.field_10499.method_9564(), false);
                blockage2 = scene.world().showIndependentSection(util.select().position(4, 1, 0), class_2350.field_11036);
                scene.world().moveSection(blockage2, util.vector().of(-2, 0, 0), 0);
            }

            if (i == 25) {
                scene.world().hideIndependentSection(blockage, class_2350.field_11033);
                scene.world().setBlock(util.grid().at(1, 1, 0), class_2246.field_10124.method_9564(), false);
                scene.world().hideIndependentSection(blockage2, class_2350.field_11033);
                scene.world().setBlock(util.grid().at(2, 1, 0), class_2246.field_10124.method_9564(), false);
            }

            if (i == 26) {
                scene.overlay().showControls(modeVec, Pointing.RIGHT, 140).showing(AllIcons.I_TUNNEL_RANDOMIZE);
                scene.world().modifyBlockEntity(
                    util.grid().at(1, 2, 3),
                    tunnelClass,
                    be -> be.getBehaviour(ServerScrollOptionBehaviour.TYPE).setValue(BrassTunnelBlockEntity.SelectionMode.RANDOMIZE.ordinal())
                );
            }

            if (i == 27) {
                scene.overlay().showText(70).attachKeyFrame().text("'Randomize' will distribute whole stacks to randomly picked outputs")
                    .pointAt(tunnelTop).placeNearTarget();
            }
        }

        scene.world().hideSection(util.select().fromTo(3, 2, 5, 1, 2, 5), class_2350.field_11036);
        scene.idle(10);
        scene.overlay().showControls(modeVec, Pointing.RIGHT, 140).showing(AllIcons.I_TUNNEL_SYNCHRONIZE);
        scene.world().modifyBlockEntity(
            util.grid().at(1, 2, 3),
            tunnelClass,
            be -> be.getBehaviour(ServerScrollOptionBehaviour.TYPE).setValue(BrassTunnelBlockEntity.SelectionMode.SYNCHRONIZE.ordinal())
        );
        scene.idle(30);
        scene.overlay().showText(70).attachKeyFrame().text("'Synchronize Inputs' is a unique setting for Brass Tunnels").pointAt(tunnelTop)
            .placeNearTarget();

        class_1799 item1 = new class_1799(class_1802.field_8179);
        class_1799 item2 = new class_1799(class_1802.field_20417);
        class_1799 item3 = AllItems.POLISHED_ROSE_QUARTZ.method_7854();

        scene.world().createItemOnBelt(util.grid().at(3, 1, 4), class_2350.field_11036, item1);
        scene.world().createItemOnBelt(util.grid().at(2, 1, 4), class_2350.field_11036, item2);
        scene.world().createItemOnBelt(util.grid().at(3, 1, 5), class_2350.field_11035, item1);
        scene.world().createItemOnBelt(util.grid().at(2, 1, 5), class_2350.field_11035, item2);

        scene.idle(80);
        scene.world().createItemOnBelt(util.grid().at(2, 1, 5), class_2350.field_11035, item2);
        scene.rotateCameraY(-90);
        scene.idle(20);
        scene.world().multiplyKineticSpeed(util.select().everywhere(), .5f);

        scene.overlay().showText(70).text("Items are only allowed past if every tunnel in the group has one waiting")
            .pointAt(util.vector().blockSurface(util.grid().at(2, 1, 4), class_2350.field_11036)).placeNearTarget().colored(PonderPalette.OUTPUT);
        scene.idle(60);
        scene.world().createItemOnBelt(util.grid().at(1, 1, 5), class_2350.field_11035, item3);
        scene.idle(90);
        scene.rotateCameraY(90);

        scene.overlay().showText(100).text("This ensures that all affected belts supply items at the same rate")
            .pointAt(util.vector().blockSurface(util.grid().at(1, 2, 3), class_2350.field_11039)).placeNearTarget().colored(PonderPalette.GREEN);
    }

}