package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;

@Mixin(value = class_776.class, priority = 999)
public class BlockRenderManagerMixin {

    @Shadow
    @Final
    private class_5819 random;

    @Shadow
    @Final
    private List<class_10889> parts;

    @Shadow
    @Final
    private class_778 blockModelRenderer;

    @Inject(method = "renderDamage(Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/BlockRenderView;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;)V", at = @At(value = "INVOKE_ASSIGN", target = "net/minecraft/client/render/block/BlockModels.getModel(Lnet/minecraft/block/BlockState;)Lnet/minecraft/client/render/model/BlockStateModel;", shift = At.Shift.AFTER), cancellable = true)
    private void renderDamage(
        class_2680 state,
        class_2338 pos,
        class_1920 world,
        class_4587 matrices,
        class_4588 vertexConsumer,
        CallbackInfo ci,
        @Local class_1087 model
    ) {
        if (WrapperBlockStateModel.unwrapCompat(model) instanceof WrapperBlockStateModel wrapper) {
            random.method_43052(state.method_26190(pos));
            parts.clear();
            wrapper.addPartsWithInfo(world, pos, state, random, parts);
            if (!parts.isEmpty()) {
                blockModelRenderer.method_3374(world, this.parts, state, pos, matrices, vertexConsumer, true, class_4608.field_21444);
            }
            ci.cancel();
        }
    }
}
