package com.zurrtum.create.client.mixin;

import com.zurrtum.create.client.flywheel.impl.visualization.VisualizationEventHandler;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import net.minecraft.class_1297;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets = "net.minecraft.client.world.ClientWorld$ClientEntityHandler")
public class ClientEntityHandlerMixin {
    @Shadow
    @Final
    class_638 field_27735;

    @Inject(method = "stopTracking(Lnet/minecraft/entity/Entity;)V", at = @At("HEAD"))
    private void onEntityLeaveLevel(class_1297 entity, CallbackInfo ci) {
        VisualizationEventHandler.onEntityLeaveLevel(field_27735, entity);
        CapabilityMinecartController.onEntityDeath(field_27735, entity);
    }
}
