package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorConnectionHandler;
import com.zurrtum.create.client.content.kinetics.mechanicalArm.ArmInteractionPointHandler;
import com.zurrtum.create.client.content.logistics.depot.EjectorTargetHandler;
import com.zurrtum.create.client.content.redstone.link.LinkHandler;
import com.zurrtum.create.client.content.trains.track.TrackPlacementClient;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueSettingsInputHandler;
import com.zurrtum.create.client.infrastructure.click.ClientRightClickHandle;
import com.zurrtum.create.client.infrastructure.click.ClientRightClickPreHandle;
import com.zurrtum.create.content.contraptions.glue.SuperGlueItem;
import com.zurrtum.create.content.equipment.clipboard.ClipboardValueSettingsHandler;
import com.zurrtum.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.zurrtum.create.content.equipment.tool.CardboardSwordItem;
import com.zurrtum.create.content.equipment.wrench.WrenchEventHandler;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlock;
import com.zurrtum.create.content.kinetics.deployer.ManualApplicationHelper;
import com.zurrtum.create.content.kinetics.simpleRelays.CogwheelBlockItem;
import com.zurrtum.create.content.logistics.funnel.FunnelItem;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerInteractionHandler;
import com.zurrtum.create.content.redstone.analogLever.AnalogLeverBlock;
import com.zurrtum.create.content.redstone.displayLink.ClickToLinkBlockItem;
import com.zurrtum.create.content.redstone.link.controller.LinkedControllerItem;
import com.zurrtum.create.content.trains.schedule.ScheduleItemEntityInteraction;
import com.zurrtum.create.foundation.block.BreakControlBlock;
import com.zurrtum.create.foundation.block.SoundControlBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.edgeInteraction.EdgeInteractionHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_746;

@Mixin(class_636.class)
public class ClientPlayerInteractionManagerMixin {
    @Shadow
    @Final
    private class_310 client;

    @Shadow
    private class_1934 gameMode;

    @Inject(method = "interactBlock(Lnet/minecraft/client/network/ClientPlayerEntity;Lnet/minecraft/util/Hand;Lnet/minecraft/util/hit/BlockHitResult;)Lnet/minecraft/util/ActionResult;", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerInteractionManager;sendSequencedPacket(Lnet/minecraft/client/world/ClientWorld;Lnet/minecraft/client/network/SequencedPacketCreator;)V"), cancellable = true)
    private void interactBlock(class_746 player, class_1268 hand, class_3965 hitResult, CallbackInfoReturnable<class_1269> cir) {
        if (gameMode == class_1934.field_9219) {
            return;
        }
        Stream.<ClientRightClickPreHandle>of(
                SuperGlueItem::glueItemAlwaysPlacesWhenUsed,
                ArmInteractionPointHandler::rightClickingBlocksSelectsThem,
                ChainConveyorConnectionHandler::onItemUsedOnBlock,
                ValueSettingsInputHandler::onBlockActivated,
                LinkHandler::onBlockActivated,
                EjectorTargetHandler::rightClickingBlocksSelectsThem
            ).map(handler -> handler.onRightClickBlock(client.field_1687, player, hand, hitResult)).filter(Objects::nonNull).findFirst()
            .ifPresentOrElse(cir::setReturnValue, () -> TrackPlacementClient.sendExtenderPacket(player, hand));
    }

    @Inject(method = "interactBlockInternal(Lnet/minecraft/client/network/ClientPlayerEntity;Lnet/minecraft/util/Hand;Lnet/minecraft/util/hit/BlockHitResult;)Lnet/minecraft/util/ActionResult;", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;getMainHandStack()Lnet/minecraft/item/ItemStack;"), cancellable = true)
    private void interactBlockInternal(
        class_746 player,
        class_1268 hand,
        class_3965 hit,
        CallbackInfoReturnable<class_1269> cir,
        @Local class_2338 pos,
        @Local class_1799 stack
    ) {
        Stream.<ClientRightClickHandle>of(
                WrenchEventHandler::useOwnWrenchLogicForCreateBlocks,
                ClipboardValueSettingsHandler::rightClickToCopy,
                ManualApplicationHelper::manualApplicationRecipesApplyInWorld,
                EdgeInteractionHandler::onBlockActivated,
                LinkedControllerItem::onItemUseFirst,
                CogwheelBlockItem::onItemUseFirst
            ).map(handler -> handler.onRightClickBlock(client.field_1687, player, stack, hand, hit, pos)).filter(Objects::nonNull).findFirst()
            .ifPresent(cir::setReturnValue);
    }

    @Inject(method = "attackBlock(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Direction;)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/tutorial/TutorialManager;onBlockBreaking(Lnet/minecraft/client/world/ClientWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;F)V"), cancellable = true)
    private void attackBlock(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> cir) {
        if (EjectorTargetHandler.leftClickingBlocksDeselectsThem(
            client.field_1724,
            pos
        ) || ArmInteractionPointHandler.leftClickingBlocksDeselectsThem(pos)) {
            cir.setReturnValue(true);
            return;
        }
        CardboardSwordItem.cardboardSwordsMakeNoiseOnClick(client.field_1724, pos);
    }

    @Inject(method = "updateBlockBreakingProgress(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Direction;)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/tutorial/TutorialManager;onBlockBreaking(Lnet/minecraft/client/world/ClientWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;F)V"), cancellable = true)
    private void updateBlockBreakingProgress(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> cir) {
        if (EjectorTargetHandler.leftClickingBlocksDeselectsThem(
            client.field_1724,
            pos
        ) || ArmInteractionPointHandler.leftClickingBlocksDeselectsThem(pos)) {
            cir.setReturnValue(true);
        }
    }

    @WrapOperation(method = "method_41936(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Direction;I)Lnet/minecraft/network/packet/Packet;", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerInteractionManager;breakBlock(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean onLeftClick1(
        class_636 instance,
        class_2338 pos,
        Operation<Boolean> original,
        @Local(argsOnly = true) class_2350 direction
    ) {
        if (ClipboardValueSettingsHandler.leftClickToPaste(client.field_1687, client.field_1724, client.field_1724.method_6047(), direction, pos)) {
            return false;
        }
        return original.call(instance, pos);
    }

    @WrapOperation(method = "method_41930(Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Direction;I)Lnet/minecraft/network/packet/Packet;", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerInteractionManager;breakBlock(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean onLeftClick2(
        class_636 instance,
        class_2338 pos,
        Operation<Boolean> original,
        @Local(argsOnly = true) class_2350 direction
    ) {
        if (ClipboardValueSettingsHandler.leftClickToPaste(client.field_1687, client.field_1724, client.field_1724.method_6047(), direction, pos)) {
            return false;
        }
        return original.call(instance, pos);
    }

    @WrapOperation(method = "method_41935(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Direction;I)Lnet/minecraft/network/packet/Packet;", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerInteractionManager;breakBlock(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean onLeftClick3(
        class_636 instance,
        class_2338 pos,
        Operation<Boolean> original,
        @Local(argsOnly = true) class_2350 direction
    ) {
        if (ClipboardValueSettingsHandler.leftClickToPaste(client.field_1687, client.field_1724, client.field_1724.method_6047(), direction, pos)) {
            return false;
        }
        return original.call(instance, pos);
    }

    @WrapOperation(method = "method_41932(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Direction;I)Lnet/minecraft/network/packet/Packet;", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerInteractionManager;breakBlock(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean onLeftClick4(
        class_636 instance,
        class_2338 pos,
        Operation<Boolean> original,
        @Local(argsOnly = true) class_2350 direction
    ) {
        if (ClipboardValueSettingsHandler.leftClickToPaste(client.field_1687, client.field_1724, client.field_1724.method_6047(), direction, pos)) {
            return false;
        }
        return original.call(instance, pos);
    }

    @WrapOperation(method = "interactBlockInternal(Lnet/minecraft/client/network/ClientPlayerEntity;Lnet/minecraft/util/Hand;Lnet/minecraft/util/hit/BlockHitResult;)Lnet/minecraft/util/ActionResult;", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;shouldCancelInteraction()Z"))
    private boolean shouldCancelInteraction(
        class_746 player,
        Operation<Boolean> original,
        @Local(argsOnly = true) class_1268 hand,
        @Local class_2338 pos,
        @Local class_1799 stack
    ) {
        if (original.call(player)) {
            class_2680 state = client.field_1687.method_8320(pos);
            return !(HandCrankBlock.onBlockActivated(hand, state, stack) || AnalogLeverBlock.onBlockActivated(
                hand,
                state,
                stack
            ) || ExtendoGripItem.shouldInteraction(player, hand, stack));
        }
        return FunnelItem.funnelItemAlwaysPlacesWhenUsed(stack) || ClickToLinkBlockItem.linkableItemAlwaysPlacesWhenUsed(client.field_1687, pos, stack);
    }

    @WrapOperation(method = "interactEntityAtLocation(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/hit/EntityHitResult;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity;interactAt(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"))
    private class_1269 interactEntityAtLocation(class_1297 entity, class_1657 player, class_243 hitPos, class_1268 hand, Operation<class_1269> original) {
        class_1269 result = ScheduleItemEntityInteraction.interactWithConductor(entity, player, hand);
        if (result != null) {
            return result;
        }
        result = StockTickerInteractionHandler.interactWithLogisticsManager(entity, player, hand);
        if (result != null) {
            return result;
        }
        return original.call(entity, player, hitPos, hand);
    }

    @WrapOperation(method = "breakBlock(Lnet/minecraft/util/math/BlockPos;)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z"))
    private boolean breakBlock(
        class_1937 world,
        class_2338 pos,
        class_2680 newState,
        int flags,
        Operation<Boolean> original,
        @Local class_2680 state,
        @Local class_2248 block
    ) {
        if (block instanceof BreakControlBlock controlBlock && !controlBlock.onDestroyedByPlayer(state, world, pos, client.field_1724)) {
            return false;
        }
        return original.call(world, pos, newState, flags);
    }

    @WrapOperation(method = "updateBlockBreakingProgress(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Direction;)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/BlockState;getSoundGroup()Lnet/minecraft/sound/BlockSoundGroup;"))
    private class_2498 getHitSound(class_2680 state, Operation<class_2498> original, @Local(argsOnly = true) class_2338 pos) {
        if (state.method_26204() instanceof SoundControlBlock block) {
            return block.getSoundGroup(client.field_1687, pos);
        }
        return original.call(state);
    }
}