package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.ContraptionHandler;
import com.zurrtum.create.infrastructure.fluids.FlowableFluid;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.lang.ref.Reference;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4048;
import net.minecraft.class_5819;
import net.minecraft.class_6862;

@Mixin(class_1297.class)
public abstract class EntityMixin {
    @Shadow
    private class_1937 world;
    @Shadow
    private class_243 pos;
    @Shadow
    private float nextStepSoundDistance;
    @Shadow
    @Final
    protected class_5819 random;
    @Shadow
    private class_4048 dimensions;
    @Unique
    private boolean inModFluid;

    @Shadow
    protected abstract void playStepSound(class_2338 pos, class_2680 state);

    @Shadow
    protected abstract float calculateNextStepSoundDistance();

    @Inject(method = "updateMovementInFluid(Lnet/minecraft/registry/tag/TagKey;D)Z", at = @At("HEAD"))
    private void clear(class_6862<class_3611> tag, double speed, CallbackInfoReturnable<Boolean> cir) {
        inModFluid = false;
    }

    @Inject(method = "updateMovementInFluid(Lnet/minecraft/registry/tag/TagKey;D)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/fluid/FluidState;getHeight(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;)F"))
    private void checkFluid(class_6862<class_3611> tag, double speed, CallbackInfoReturnable<Boolean> cir, @Local class_3610 state) {
        if (!inModFluid) {
            inModFluid = state.method_15772() instanceof FlowableFluid;
        }
    }

    @Inject(method = "onSwimmingStart()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;addParticleClient(Lnet/minecraft/particle/ParticleEffect;DDDDDD)V"), cancellable = true)
    private void cancelEffect(CallbackInfo ci) {
        if (inModFluid) {
            ci.cancel();
        }
    }

    @Unique
    private Stream<AbstractContraptionEntity> create$getIntersectionContraptionsStream() {
        return (world.field_9236 ? ContraptionHandlerClient.loadedContraptions : ContraptionHandler.loadedContraptions).get(world).values().stream()
            .map(Reference::get).filter(cEntity -> cEntity != null && cEntity.collidingEntities.containsKey((class_1297) (Object) this));
    }

    @Unique
    private Set<AbstractContraptionEntity> create$getIntersectingContraptions() {
        Set<AbstractContraptionEntity> contraptions = create$getIntersectionContraptionsStream().collect(Collectors.toSet());

        contraptions.addAll(world.method_18467(AbstractContraptionEntity.class, ((class_1297) (Object) this).method_5829().method_1014(1f)));
        return contraptions;
    }

    @Unique
    private void create$forCollision(class_243 worldPos, TriConsumer<Contraption, class_2680, class_2338> action) {
        create$getIntersectingContraptions().forEach(cEntity -> {
            class_243 localPos = ContraptionCollider.worldToLocalPos(worldPos, cEntity);

            class_2338 blockPos = class_2338.method_49638(localPos);
            Contraption contraption = cEntity.getContraption();
            class_3499.class_3501 info = contraption.getBlocks().get(blockPos);

            if (info != null) {
                class_2680 blockstate = info.comp_1342();
                action.accept(contraption, blockstate, blockPos);
            }
        });
    }

    // involves block step sounds on contraptions
    // injecting before `!blockstate1.isAir(this.world, blockpos)`
    // `if (this.moveDist > this.nextStep && !blockstate1.isAir())
    @Inject(method = "applyMoveEffect(Lnet/minecraft/entity/Entity$MoveEffect;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/BlockState;isAir()Z", ordinal = 0))
    private void create$contraptionStepSounds(
        class_1297.class_5799 moveEffect,
        class_243 movement,
        class_2338 landingPos,
        class_2680 landingState,
        CallbackInfo ci
    ) {
        class_243 worldPos = pos.method_1031(0, -0.2, 0);
        MutableBoolean stepped = new MutableBoolean(false);

        create$forCollision(
            worldPos, (contraption, state, pos) -> {
                playStepSound(pos, state);
                stepped.setTrue();
            }
        );

        if (stepped.booleanValue())
            nextStepSoundDistance = calculateNextStepSoundDistance();
    }

    // involves client-side view bobbing animation on contraptions
    @Inject(method = "move(Lnet/minecraft/entity/MovementType;Lnet/minecraft/util/math/Vec3d;)V", at = @At(value = "TAIL"))
    private void create$onMove(class_1313 type, class_243 movement, CallbackInfo ci) {
        if (!world.field_9236)
            return;
        class_1297 self = (class_1297) (Object) this;
        if (self.method_24828())
            return;
        if (self.method_5765())
            return;

        class_243 worldPos = pos.method_1031(0, -0.2, 0);
        boolean onAtLeastOneContraption = create$getIntersectionContraptionsStream().anyMatch(cEntity -> {
            class_243 localPos = ContraptionCollider.worldToLocalPos(worldPos, cEntity);

            class_2338 blockPos = class_2338.method_49638(localPos);
            Contraption contraption = cEntity.getContraption();
            class_3499.class_3501 info = contraption.getBlocks().get(blockPos);

            if (info == null)
                return false;

            cEntity.registerColliding(self);
            return true;
        });

        if (!onAtLeastOneContraption)
            return;

        self.method_24830(true);
        AllSynchedDatas.CONTRAPTION_GROUNDED.set(self, true);
    }

    @Inject(method = "spawnSprintingParticles()V", at = @At(value = "TAIL"))
    private void create$onSpawnSprintParticle(CallbackInfo ci) {
        class_1297 self = (class_1297) (Object) this;
        class_243 worldPos = pos.method_1031(0, -0.2, 0);

        create$forCollision(
            worldPos, (contraption, state, pos) -> {
                if (state.method_26217() != class_2464.field_11455) {
                    class_243 speed = self.method_18798();
                    world.method_8406(
                        new class_2388(class_2398.field_11217, state),
                        self.method_23317() + ((double) random.method_43057() - 0.5D) * (double) dimensions.comp_2185(),
                        self.method_23318() + 0.1D,
                        self.method_23321() + ((double) random.method_43057() - 0.5D) * (double) dimensions.comp_2186(),
                        speed.field_1352 * -4.0D,
                        1.5D,
                        speed.field_1350 * -4.0D
                    );
                }
            }
        );
    }
}
