package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.client.foundation.item.TooltipModifier;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.client.ponder.foundation.PonderTooltipHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

@Mixin(class_1799.class)
public abstract class ItemStackMixin {
    @Shadow
    public abstract class_1792 getItem();

    @ModifyReturnValue(method = "getTooltip", at = @At("RETURN"))
    private List<class_2561> appendTooltip(List<class_2561> tooltip, @Local(argsOnly = true) class_1657 player) {
        PonderTooltipHandler.addToTooltip(tooltip, (class_1799) (Object) this);
        if (!AllConfigs.client().tooltips.get() || player == null)
            return tooltip;
        TooltipModifier modifier = TooltipModifier.REGISTRY.get(getItem());
        if (modifier != null) {
            modifier.modify(tooltip, player);
        }
        return tooltip;
    }
}
