/*
 * Copyright (c) Forge Development LLC and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */

package com.zurrtum.create.client.model.obj;

import com.zurrtum.create.client.model.AbstractUnbakedModel;
import com.zurrtum.create.client.model.LayerUnbakedModel;
import com.zurrtum.create.client.model.StandardModelParameters;
import net.minecraft.class_10820;
import net.minecraft.class_11515;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

/**
 * A model loaded from an OBJ file.
 * <p>
 * Supports positions, texture coordinates, normals and colors. The {@link ObjMaterialLibrary material library}
 * has support for numerous features, including support for {@link class_2960} textures (non-standard).
 */
public class ObjModel extends AbstractUnbakedModel implements LayerUnbakedModel {
    private final ObjGeometry geometry;

    public ObjModel(StandardModelParameters parameters, ObjGeometry geometry) {
        super(parameters);
        this.geometry = geometry;
    }

    @Override
    public class_10820 comp_3739() {
        return geometry;
    }

    @Override
    @Nullable
    public class_11515 create$getBlockRenderLayer() {
        return parameters.layer();
    }
}
