package com.zurrtum.create.client.ponder.foundation;

import com.zurrtum.create.client.ponder.api.registration.StoryBoardEntry;
import com.zurrtum.create.client.ponder.api.scene.PonderStoryBoard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2960;

public class PonderStoryBoardEntry implements StoryBoardEntry {

    private final PonderStoryBoard board;
    private final String namespace;
    private final class_2960 schematicLocation;
    private final class_2960 component;
    private final List<class_2960> tags;
    private final List<SceneOrderingEntry> orderingEntries;

    public PonderStoryBoardEntry(PonderStoryBoard board, String namespace, class_2960 schematicLocation, class_2960 component) {
        this.board = board;
        this.namespace = namespace;
        this.schematicLocation = schematicLocation;
        this.component = component;
        this.tags = new ArrayList<>();
        this.orderingEntries = new ArrayList<>();
    }

    public PonderStoryBoardEntry(PonderStoryBoard board, String namespace, String schematicPath, class_2960 component) {
        this(board, namespace, class_2960.method_60655(namespace, schematicPath), component);
    }

    @Override
    public PonderStoryBoard getBoard() {
        return board;
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    @Override
    public class_2960 getSchematicLocation() {
        return schematicLocation;
    }

    @Override
    public class_2960 getComponent() {
        return component;
    }

    @Override
    public List<class_2960> getTags() {
        return tags;
    }

    @Override
    public List<SceneOrderingEntry> getOrderingEntries() {
        return orderingEntries;
    }

    // Builder start

    @Override
    public StoryBoardEntry orderBefore(String namespace, String otherSceneId) {
        this.orderingEntries.add(SceneOrderingEntry.before(namespace, otherSceneId));
        return this;
    }

    @Override
    public StoryBoardEntry orderAfter(String namespace, String otherSceneId) {
        this.orderingEntries.add(SceneOrderingEntry.after(namespace, otherSceneId));
        return this;
    }

    @Override
    public StoryBoardEntry highlightTag(class_2960 tag) {
        tags.add(tag);
        return this;
    }

    @Override
    public StoryBoardEntry highlightTags(class_2960... tags) {
        Collections.addAll(this.tags, tags);
        return this;
    }

    @Override
    public StoryBoardEntry highlightAllTags() {
        tags.add(PonderTag.Highlight.ALL);
        return this;
    }

}