package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import java.util.function.UnaryOperator;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_5455;
import net.minecraft.class_8942;

public class BlockEntityDataInstruction extends WorldModifyInstruction {

    private final boolean redraw;
    private final UnaryOperator<class_2487> data;
    private final Class<? extends class_2586> type;

    public BlockEntityDataInstruction(Selection selection, Class<? extends class_2586> type, UnaryOperator<class_2487> data, boolean redraw) {
        super(selection);
        this.type = type;
        this.data = data;
        this.redraw = redraw;
    }

    @Override
    protected void runModification(Selection selection, PonderScene scene) {
        PonderLevel level = scene.getWorld();
        selection.forEach(pos -> {
            if (!level.getBounds().method_14662(pos))
                return;
            class_2586 blockEntity = level.method_8321(pos);
            if (!type.isInstance(blockEntity))
                return;
            class_5455 registryManager = level.method_30349();
            class_2487 apply = data.apply(blockEntity.method_38242(registryManager));
            //if (blockEntity instanceof SyncedBlockEntity) //TODO
            //	((SyncedBlockEntity) blockEntity).readClient(apply);
            try (class_8942.class_11340 logging = new class_8942.class_11340(blockEntity.method_71402(), Ponder.LOGGER)) {
                class_11368 view = class_11352.method_71417(logging, registryManager, apply);
                blockEntity.method_58690(view);
            }
        });
    }

    @Override
    protected boolean needsRedraw() {
        return redraw;
    }

}
