package com.zurrtum.create.client.ponder.foundation.ui;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.BoxWidget;
import com.zurrtum.create.client.ponder.foundation.PonderTag;
import org.jetbrains.annotations.Nullable;

import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class PonderButton extends BoxWidget {

    public static final Couple<Color> COLOR_IDLE = Couple.create(new Color(0x60_c0c0ff, true), new Color(0x30_c0c0ff, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_HOVER = Couple.create(new Color(0xf0_c0c0ff, true), new Color(0xa0_c0c0ff, true))
        .map(Color::setImmutable);
    public static final Couple<Color> COLOR_CLICK = Couple.create(new Color(0xff_ffffff, true), new Color(0xdd_ffffff, true))
        .map(Color::setImmutable);
    public static final Couple<Color> COLOR_DISABLED = Couple.create(new Color(0x80_909090, true), new Color(0x20_909090, true))
        .map(Color::setImmutable);

    @Nullable
    protected class_1799 item;
    @Nullable
    protected PonderTag tag;
    @Nullable
    protected class_304 shortcut;
    protected LerpedFloat flash = LerpedFloat.linear().startWithValue(0).chase(0, 0.1f, LerpedFloat.Chaser.EXP);

    public PonderButton(int x, int y) {
        this(x, y, 20, 20);
    }

    public PonderButton(int x, int y, int width, int height) {
        super(x, y, width, height);
        z = 420;
        paddingX = 2;
        paddingY = 2;
        colorIdle = COLOR_IDLE;
        colorHover = COLOR_HOVER;
        colorClick = COLOR_CLICK;
        colorDisabled = COLOR_DISABLED;
        updateGradientFromState();
    }

    public <T extends PonderButton> T withShortcut(class_304 key) {
        this.shortcut = key;
        //noinspection unchecked
        return (T) this;
    }

    public <T extends PonderButton> T showingTag(PonderTag tag) {
        return showing(this.tag = tag);
    }

    public <T extends PonderButton> T showing(class_1799 item) {
        this.item = item;
        return super.showingElement(GuiGameElement.of(item).scale(1.5f).at(-4, -4));
    }

    public void flash() {
        flash.updateChaseTarget(1);
    }

    public void dim() {
        flash.updateChaseTarget(0);
    }

    @Override
    public void tick() {
        super.tick();
        flash.tickChaser();
    }

    @Override
    protected void beforeRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(graphics, mouseX, mouseY, partialTicks);

        float flashValue = flash.getValue(partialTicks);
        if (flashValue > .1f) {
            float sin = 0.5f + 0.5f * class_3532.method_15374((AnimationTickHolder.getTicks(true) + partialTicks) / 10f);
            sin *= flashValue;
            Color nc1 = new Color(255, 255, 255, class_3532.method_15340(gradientColor.getFirst().getAlpha() + 150, 0, 255));
            Color nc2 = new Color(155, 155, 155, class_3532.method_15340(gradientColor.getSecond().getAlpha() + 150, 0, 255));
            Couple<Color> newColors = Couple.create(nc1, nc2);
            float finalSin = sin;
            gradientColor = gradientColor.mapWithParams((color, other) -> color.mixWith(other, finalSin), newColors);
        }
    }

    @Override
    public void doRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.doRender(graphics, mouseX, mouseY, partialTicks);

        if (!isVisible())
            return;

        if (shortcut != null) {
            graphics.method_25300(
                graphics.field_44656.field_1772,
                shortcut.method_16007().getString().toLowerCase(Locale.ROOT),
                method_46426() + field_22758 / 2 + 8,
                method_46427() + field_22759 - 6,
                UIRenderHelper.COLOR_TEXT_DARKER.getFirst().scaleAlpha(fade.getValue()).getRGB()
            );
        }
    }

    @Override
    public boolean method_25370() {
        return false;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (shortcut != null && shortcut.method_1417(keyCode, scanCode)) {
            gradientColor = getColorClick();
            startGradientAnimation(getColorForState(), 0.15);

            runCallback(field_22758 / 2f, field_22759 / 2f);
            return true;
        }

        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    protected boolean method_25351(int i) {
        return isVisible();
    }

    @Nullable
    public class_1799 getItem() {
        return item;
    }

    @Nullable
    public PonderTag getTag() {
        return tag;
    }

    public boolean isVisible() {
        return !(fade.getValue() < .1f);
    }

    public void clear() {
        if (tag != null) {
            tag.clear();
        }
        if (element != null) {
            element.clear();
        }
    }
}