package com.zurrtum.create.client.vanillin.item;

import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.model.Mesh;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.lib.material.Materials;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.ModelUtil;
import com.zurrtum.create.client.flywheel.lib.model.SimpleModel;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedItemModelBufferer;
import com.zurrtum.create.client.flywheel.lib.model.baked.ItemChunkLayerSortedListBuilder;
import com.zurrtum.create.client.flywheel.lib.model.baked.MeshHelper;
import com.zurrtum.create.client.flywheel.lib.util.RendererReloadCache;
import com.zurrtum.create.client.vanillin.Vanillin;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenCustomHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_10439;
import net.minecraft.class_10444;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_811;
import net.minecraft.class_9334;

public class ItemModels {
    public static final class_6862<class_1792> NO_INSTANCING = class_6862.method_40092(class_7924.field_41197, Vanillin.rl("no_instancing"));
    private static final Model EMPTY_MODEL = new SimpleModel(List.of());
    private static final RendererReloadCache<BakedModelKey, Model> MODEL_CACHE = new RendererReloadCache<>(key -> bakeModel(
        key.world(),
        key.stack(),
        key.displayContext()
    ));
    private static final Map<class_1799, Boolean> SUPPORT_CACHE = new Object2BooleanLinkedOpenCustomHashMap<>(new Hash.Strategy<>() {
        public int hashCode(class_1799 itemStack) {
            return class_1799.method_57355(itemStack);
        }

        public boolean equals(class_1799 itemStack, class_1799 itemStack2) {
            return itemStack == itemStack2 || itemStack != null && itemStack2 != null && class_1799.method_31577(itemStack, itemStack2);
        }
    });
    private static final ThreadLocal<class_10444> STATE = ThreadLocal.withInitial(class_10444::new);

    public static boolean isSupported(class_1799 stack, class_811 context) {
        if (stack.method_31573(NO_INSTANCING)) {
            return false;
        }
        Boolean cache = SUPPORT_CACHE.get(stack);
        if (cache != null) {
            return cache;
        }
        class_310 mc = class_310.method_1551();
        class_10444 state = STATE.get();
        mc.method_65386().method_65598(state, stack, context, mc.field_1687, null, 0);
        boolean support = !state.method_70948();
        SUPPORT_CACHE.put(stack, support);
        return support;
    }

    public static class_10439 getModel(class_1799 stack) {
        return class_310.method_1551().method_1554().method_65746(stack.method_58694(class_9334.field_54199));
    }

    public static Model get(class_1937 world, class_1799 itemStack, class_811 displayContext) {
        if (itemStack.method_7960()) {
            return EMPTY_MODEL;
        }
        class_638 clientWorld = world instanceof class_638 ? (class_638) world : null;
        return MODEL_CACHE.get(new BakedModelKey(clientWorld, itemStack, displayContext));
    }

    public static Model bakeModel(class_638 world, class_1799 itemStack, class_811 displayContext) {
        var builder = ItemChunkLayerSortedListBuilder.<Model.ConfiguredMesh>getThreadLocal();
        BakedItemModelBufferer.bufferItemStack(
            itemStack, world, displayContext, (renderType, shaded, data) -> {
                var material = ModelUtil.getItemMaterial(renderType);
                if (material == null) {
                    material = Materials.TRANSLUCENT_ENTITY;
                }
                if (itemStack.method_7909() instanceof class_1747 && material.transparency() == Transparency.TRANSLUCENT) {
                    material = SimpleMaterial.builderOf(material).transparency(Transparency.ORDER_INDEPENDENT).build();
                }
                Mesh mesh = MeshHelper.blockVerticesToMesh(data, "source=ItemModels,ItemStack=" + itemStack + ",renderType=" + renderType);
                builder.add(renderType, new Model.ConfiguredMesh(material, mesh));
            }, (renderType, material, mesh) -> {
                if (itemStack.method_7909() instanceof class_1747 && material.transparency() == Transparency.TRANSLUCENT) {
                    material = SimpleMaterial.builderOf(material).transparency(Transparency.ORDER_INDEPENDENT).build();
                }
                builder.add(renderType, new Model.ConfiguredMesh(material, mesh));
            }
        );
        return new SimpleModel(builder.build());
    }

    public record BakedModelKey(class_638 world, class_1799 stack, class_811 displayContext) {
        @Override
        public int hashCode() {
            return Objects.hash(world, class_1799.method_57355(stack), displayContext);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof BakedModelKey(ClientWorld otherWorld, ItemStack otherStack, ItemDisplayContext otherDisplayContext))) {
                return false;
            }
            boolean stackEqual = stack == otherStack || class_1799.method_31577(stack, otherStack);
            return world == otherWorld && stackEqual && displayContext == otherDisplayContext;
        }
    }
}
