package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.util.InstanceRecycler;
import com.zurrtum.create.client.vanillin.item.ItemModels;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1944;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_811;

public class ItemVisual extends AbstractEntityVisual<class_1542> implements SimpleDynamicVisual {

    private static final ThreadLocal<class_5819> RANDOM = ThreadLocal.withInitial(class_5819::method_43053);

    private final class_4587 pPoseStack = new class_4587();
    private final class_10444 itemRenderState = new class_10444();
    private class_10439 itemModel;
    private Model currentModel;
    private class_1799 currentStack;

    private final InstanceRecycler<TransformedInstance> instances;

    public ItemVisual(VisualizationContext ctx, class_1542 entity, float partialTick) {
        super(ctx, entity, partialTick);

        updateModel(entity.method_6983());

        instances = new InstanceRecycler<>(this::getInstance);

        animate(partialTick);
    }

    public static boolean isSupported(class_1542 entity) {
        if (entity.getClass() != class_1542.class) {
            return false;
        }
        return ItemModels.isSupported(entity.method_6983(), class_811.field_4318);
    }

    @Override
    public void beginFrame(Context ctx) {
        if (!isVisible(ctx.frustum())) {
            return;
        }

        class_1799 stack = entity.method_6983();
        if (!class_1799.method_31577(currentStack, stack)) {
            updateModel(stack);
            instances.delete();
        }
        animate(ctx.partialTick());
    }

    private void updateModel(class_1799 stack) {
        currentStack = stack.method_7972();
        itemModel = ItemModels.getModel(currentStack);
        currentModel = ItemModels.get(level, currentStack, class_811.field_4318);
    }

    private TransformedInstance getInstance() {
        return visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, currentModel).createInstance();
    }

    private void animate(float partialTick) {
        pPoseStack.method_34426();
        TransformStack.of(pPoseStack).translate(getVisualPosition(partialTick));

        instances.resetCount();

        class_1799 itemstack = entity.method_6983();
        if (itemstack.method_7960()) {
            return;
        }

        itemRenderState.method_65605();
        class_10442 manager = class_310.method_1551().method_65386();
        class_638 world = entity.method_37908() instanceof class_638 clientWorld ? clientWorld : null;
        itemRenderState.field_55337 = class_811.field_4318;
        itemModel.method_65584(itemRenderState, itemstack, manager, class_811.field_4318, world, null, entity.method_5628());

        if (itemRenderState.method_65606()) {
            return;
        }

        float age = entity.method_6985() + partialTick;
        class_238 box = itemRenderState.method_72173();
        float f = -((float) box.field_1322) + 0.0625F;
        if (shouldBob()) {
            float g = class_3532.method_15374(age / 10.0F + entity.field_7203) * 0.1F + 0.1F;
            pPoseStack.method_46416(0.0F, g + f, 0.0F);
        } else {
            pPoseStack.method_46416(0.0F, f, 0.0F);
        }
        float h = class_1542.method_27314(age, entity.field_7203);
        pPoseStack.method_22907(class_7833.field_40716.rotation(h));

        int i = this.getRenderAmount(itemstack);
        int seed = itemstack.method_7960() ? 187 : class_1792.method_7880(itemstack.method_7909()) + itemstack.method_7919();
        var random = RANDOM.get();
        random.method_43052(seed);

        int light = class_765.method_23687(
            level.method_8314(class_1944.field_9282, entity.method_24515()),
            level.method_8314(class_1944.field_9284, entity.method_24515())
        );

        float lengthZ = (float) box.method_17941();
        if (lengthZ > 0.0625F) {
            instances.get().setTransform(pPoseStack.method_23760()).light(light).setChanged();

            if (shouldSpreadItems()) {
                for (int j = 1; j < i; j++) {
                    pPoseStack.method_22903();
                    float x = (random.method_43057() * 2.0F - 1.0F) * 0.15F;
                    float y = (random.method_43057() * 2.0F - 1.0F) * 0.15F;
                    float z = (random.method_43057() * 2.0F - 1.0F) * 0.15F;
                    pPoseStack.method_46416(x, y, z);
                    instances.get().setTransform(pPoseStack.method_23760()).light(light).setChanged();
                    pPoseStack.method_22909();
                }
            }
        } else {
            float l = lengthZ * 1.5F;
            pPoseStack.method_46416(0.0F, 0.0F, -(l * (i - 1) / 2.0F));
            instances.get().setTransform(pPoseStack.method_23760()).light(light).setChanged();
            pPoseStack.method_46416(0.0F, 0.0F, l);

            if (shouldSpreadItems()) {
                for (int m = 1; m < i; m++) {
                    pPoseStack.method_22903();
                    float x = (random.method_43057() * 2.0F - 1.0F) * 0.15F * 0.5F;
                    float y = (random.method_43057() * 2.0F - 1.0F) * 0.15F * 0.5F;
                    pPoseStack.method_46416(x, y, 0.0F);
                    instances.get().setTransform(pPoseStack.method_23760()).light(light).setChanged();
                    pPoseStack.method_22909();
                    pPoseStack.method_46416(0.0F, 0.0F, l);
                }
            }
        }

        instances.discardExtra();
    }

    protected int getRenderAmount(class_1799 pStack) {
        int i = 1;
        if (pStack.method_7947() > 48) {
            i = 5;
        } else if (pStack.method_7947() > 32) {
            i = 4;
        } else if (pStack.method_7947() > 16) {
            i = 3;
        } else if (pStack.method_7947() > 1) {
            i = 2;
        }

        return i;
    }

    /**
     * @return If items should spread out when rendered in 3D
     */
    public boolean shouldSpreadItems() {
        return true;
    }

    /**
     * @return If items should have a bob effect
     */
    public boolean shouldBob() {
        return true;
    }

    @Override
    protected void _delete() {
        instances.delete();
    }

}
