package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.compat.rei.IngredientHelper;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.fluids.transfer.EmptyingRecipe;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidItemInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.display.DisplayConsumer;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

import static com.zurrtum.create.Create.MOD_ID;

public record DrainingDisplay(
    EntryIngredient input, EntryIngredient output, EntryIngredient result, Optional<class_2960> location
) implements Display {
    public static final class_2960 POTIONS = class_2960.method_60655(MOD_ID, "potions");
    public static final DisplaySerializer<DrainingDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            EntryIngredient.codec().fieldOf("input").forGetter(DrainingDisplay::input),
            EntryIngredient.codec().fieldOf("output").forGetter(DrainingDisplay::output),
            EntryIngredient.codec().fieldOf("result").forGetter(DrainingDisplay::result),
            class_2960.field_25139.optionalFieldOf("location").forGetter(DrainingDisplay::location)
        ).apply(instance, DrainingDisplay::new)), class_9139.method_56905(
            EntryIngredient.streamCodec(),
            DrainingDisplay::input,
            EntryIngredient.streamCodec(),
            DrainingDisplay::output,
            EntryIngredient.streamCodec(),
            DrainingDisplay::result,
            class_9135.method_56382(class_2960.field_48267),
            DrainingDisplay::location,
            DrainingDisplay::new
        )
    );

    public DrainingDisplay(class_8786<EmptyingRecipe> entry) {
        this(entry.comp_1932().method_29177(), entry.comp_1933());
    }

    public DrainingDisplay(class_2960 id, EmptyingRecipe recipe) {
        this(
            EntryIngredients.ofIngredient(recipe.ingredient()),
            IngredientHelper.createEntryIngredient(recipe.fluidResult()),
            EntryIngredients.of(recipe.result()),
            Optional.of(id)
        );
    }

    public static void register(Stream<EntryStack<?>> itemStream, DisplayConsumer registry) {
        itemStream.forEach(entry -> {
            class_1799 stack = entry.castValue();
            if (PotionFluidHandler.isPotionItem(stack)) {
                registry.add(new DrainingDisplay(
                    EntryIngredients.of(stack),
                    IngredientHelper.createEntryIngredient(PotionFluidHandler.getFluidFromPotionItem(stack)),
                    EntryIngredients.of(class_1802.field_8469),
                    Optional.of(POTIONS)
                ));
                return;
            }
            try (FluidItemInventory capability = FluidHelper.getFluidInventory(stack.method_7972())) {
                if (capability == null) {
                    return;
                }
                FluidStack fluid = capability.extractAny(81000);
                if (fluid.isEmpty()) {
                    return;
                }
                class_2960 itemName = class_7923.field_41178.method_10221(stack.method_7909());
                class_2960 fluidName = class_7923.field_41173.method_10221(fluid.getFluid());
                class_2960 id = class_2960.method_60655(
                    MOD_ID,
                    "empty_" + itemName.method_12836() + "_" + itemName.method_12832() + "_with_" + fluidName.method_12836() + "_" + fluidName.method_12832()
                );
                registry.add(new DrainingDisplay(
                    EntryIngredients.of(stack),
                    IngredientHelper.createEntryIngredient(fluid),
                    EntryIngredients.of(capability.getContainer()),
                    Optional.of(id)
                ));
            }
        });
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return List.of(input);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return List.of(output, result);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.DRAINING;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
