package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_2960;
import net.minecraft.class_3862;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Optional;

public record FanSmokingDisplay(EntryIngredient input, EntryIngredient output, Optional<class_2960> location) implements Display {
    public static final DisplaySerializer<FanSmokingDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            EntryIngredient.codec().fieldOf("input").forGetter(FanSmokingDisplay::input),
            EntryIngredient.codec().fieldOf("output").forGetter(FanSmokingDisplay::output),
            class_2960.field_25139.optionalFieldOf("location").forGetter(FanSmokingDisplay::location)
        ).apply(instance, FanSmokingDisplay::new)), class_9139.method_56436(
            EntryIngredient.streamCodec(),
            FanSmokingDisplay::input,
            EntryIngredient.streamCodec(),
            FanSmokingDisplay::output,
            class_9135.method_56382(class_2960.field_48267),
            FanSmokingDisplay::location,
            FanSmokingDisplay::new
        )
    );

    public static Display of(class_8786<class_3862> entry) {
        if (!AllRecipeTypes.CAN_BE_AUTOMATED.test(entry)) {
            return null;
        }
        class_3862 recipe = entry.comp_1933();
        return new FanSmokingDisplay(
            EntryIngredients.ofIngredient(recipe.method_64720()),
            EntryIngredients.of(recipe.method_64721()),
            Optional.of(entry.comp_1932().method_29177())
        );
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return List.of(input);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return List.of(output);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.FAN_SMOKING;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
