package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.compat.rei.IngredientHelper;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.kinetics.press.PressingRecipe;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Optional;

public record PressingDisplay(EntryIngredient input, EntryIngredient output, Optional<class_2960> location) implements Display {
    public static final DisplaySerializer<PressingDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            EntryIngredient.codec().fieldOf("inputs").forGetter(PressingDisplay::input),
            EntryIngredient.codec().fieldOf("output").forGetter(PressingDisplay::output),
            class_2960.field_25139.optionalFieldOf("location").forGetter(PressingDisplay::location)
        ).apply(instance, PressingDisplay::new)), class_9139.method_56436(
            EntryIngredient.streamCodec(),
            PressingDisplay::input,
            EntryIngredient.streamCodec(),
            PressingDisplay::output,
            class_9135.method_56382(class_2960.field_48267),
            PressingDisplay::location,
            PressingDisplay::new
        )
    );

    public PressingDisplay(class_8786<PressingRecipe> entry) {
        this(entry.comp_1932().method_29177(), entry.comp_1933());
    }

    public PressingDisplay(class_2960 id, PressingRecipe recipe) {
        this(IngredientHelper.getInputEntryIngredient(recipe.ingredient()), EntryIngredients.of(recipe.result()), Optional.of(id));
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return List.of(input);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return List.of(output);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.PRESSING;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
